<?php
session_start();
$mobile = $_SESSION["mobile"]; 

$uploadDir1 = 'uploads/passport_photos/';
$uploadDir2 = 'uploads/address_proofs/';
$uploadDir3 = 'uploads/degree_certificates/';

include '../../../config/db.php'; 

$conn = new mysqli($servername, $username, $password, $database);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check connection
    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Initialize variables for file paths
    $passport_photo_path = "";
    $address_proof_path = "";
    $degree_certificate_path = "";

    // Upload passport photo (file1)
    if (isset($_FILES['file1']) && $_FILES['file1']['error'] == UPLOAD_ERR_OK) {
        $filename = $_FILES['file1']['name'];
        $tmpFilePath = $_FILES['file1']['tmp_name'];
        $newFilePath = $uploadDir1 . $filename;

        if (move_uploaded_file($tmpFilePath, $newFilePath)) {
            $passport_photo_path = $newFilePath;
        } else {
            echo "Error uploading passport photo: " . $filename . "<br>";
            exit;
        }
    }

    // Upload address proof (file2)
    if (isset($_FILES['file2']) && $_FILES['file2']['error'] == UPLOAD_ERR_OK) {
        $filename = $_FILES['file2']['name'];
        $tmpFilePath = $_FILES['file2']['tmp_name'];
        $newFilePath = $uploadDir2 . $filename;

        if (move_uploaded_file($tmpFilePath, $newFilePath)) {
            $address_proof_path = $newFilePath;
        } else {
            echo "Error uploading address proof: " . $filename . "<br>";
            exit;
        }
    }

    // Upload degree certificate (file3)
    if (isset($_FILES['file3']) && $_FILES['file3']['error'] == UPLOAD_ERR_OK) {
        $filename = $_FILES['file3']['name'];
        $tmpFilePath = $_FILES['file3']['tmp_name'];
        $newFilePath = $uploadDir3 . $filename;

        if (move_uploaded_file($tmpFilePath, $newFilePath)) {
            $degree_certificate_path = $newFilePath;
        } else {
            echo "Error uploading degree certificate: " . $filename . "<br>";
            exit;
        }
    }

    // Prepare and bind the SQL statement for updating the database
    $stmt = $conn->prepare("UPDATE application_form SET passport_photo_path=?, address_proof_path=?, degree_certificate_path=?, statusapp='Document_uploaded' WHERE mobile=?");

    // Bind parameters
    $stmt->bind_param("ssss", $passport_photo_path, $address_proof_path, $degree_certificate_path, $mobile);

    // Execute the SQL statement
    if ($stmt->execute()) {
        echo "Document Upload Successfully.";
    } else {
        echo "Error: " . $stmt->error;
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();
}
?>
