<?php
require_once './vendor/autoload.php'; // Include PHPMailer autoload file
require_once '../../../../config/db.php'; 
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

if (isset($_GET['file']) && isset($_GET['userID'])) {
    $pdfFilePath = urldecode($_GET['file']);
    $userId = urldecode($_GET['userID']);

    // Check if the file exists
    if (!file_exists($pdfFilePath)) {
        echo "File not found.";
        exit();
    }

    // Fetch user data from application_form table
    $stmt = $conn->prepare("SELECT first_name, email FROM application_form WHERE app_no = ?");
    $stmt->bind_param("s", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo "User not found.";
        exit();
    }

    $userData = $result->fetch_assoc();
    $stmt->close();
    $conn->close();

    // Send the PDF as an email attachment using PHPMailer
    $mail = new PHPMailer(true);

   try {
        //Server settings
        $mail->SMTPDebug = 0; // Enable verbose debug output (change to 0 for production)
        $mail->isSMTP(); // Set mailer to use SMTP
        $mail->Host = 'smtp.gmail.com'; // Specify main and backup SMTP servers
        $mail->SMTPAuth = true; // Enable SMTP authentication
        $mail->Username = 'sakthicodedev@gmail.com'; // SMTP username
        $mail->Password = 'ikdw txuj tsnb oyux'; // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS; // Enable TLS encryption, `PHPMailer::ENCRYPTION_SMTPS` also accepted
        $mail->Port = 587; // TCP port to connect to

        //Recipients
        $mail->setFrom('sakthicodedev@gmail.com', 'EDII-TN');
        $mail->addAddress($userData['email'], $userData['first_name']); 

        // Attachments
        $mail->addAttachment($pdfFilePath); // Add attachments

        // Content
        $mail->isHTML(true); // Set email format to HTML
        $mail->Subject = 'Your Application No:'.$userId.'';
        $mail->Body = '
        <div style="font-family: Arial, sans-serif; max-width: 600px; margin: auto; padding: 20px; border: 1px solid #ddd; border-radius: 10px;">
            <div style="text-align: center; margin-bottom: 20px;">
                <img src="https://tnedii.helloindiasolutions.com/management/form/admissions/formenter/mail/logo.png" alt="Company Logo" style="max-width: 350px;">
            </div>
            <div style="background: #f9f9f9; padding: 20px; border-radius: 10px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                <h2 style="color: #333;">Hi ' . $userData['first_name'] . ',</h2>
                <p style="color: #333;">
                    Thanks for your registration.<br><br>
                     </p>  <p style="color: #333;">Your Application No:'.$userId.' <br> </p> 
                       <p style="color: #555;">
                    Note: We are in the process of verifying your application. You can see the status of your application on your dashboard.  
                </p>
                <p style="color: #555;">Thanks,<br>EDII-TN</p>
            </div>
        </div>';

        $mail->send();
        echo 'Message has been sent';
    } catch (Exception $e) {
        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
    }

    header("Location: ../index.php");
    exit();
} else {
    echo "No file or user ID specified.";
}