(function () {
    autoFill = function (forms,options) {
        var identifier = forms.map(function (obj, i) {
            return obj.id + obj.name;
        }).join();
        var autoFill = AutoFill.getInstance(identifier);
        autoFill.protect(forms, options);
        return autoFill
    };
    var storage = window.JotStorage ? window.JotStorage : $.jStorage;
    var jotFormBrowserStorage =
    {
        debugIsOn: false,

        isAvailable: function()
        {
            if (typeof storage === "object") return true;
            else return false;
        },
        set: function (key, value)
        {
            storage.set(key, value + "");
        },
        get: function (key)
        {
            var result = storage.get(key);
            return result ? result.toString() : result;
        },
        remove: function (key) {
          typeof storage.remove === "function" ? storage.remove(key): storage.deleteKey(key);
        },
        timeNow: function()
        {
            return +new Date;
        },
        secToMil: function(sec)
        {
            return ( Number(sec) * 1000 );
        },
        setTTL: function(formID, ttl)
        {
            var c_ttl = this.getTTLs();
            if ( !c_ttl ) c_ttl = {};

            //if the formID is already in the ttl list
            //check each key if needs to be delete
            var timeNow = this.timeNow();
            if ( c_ttl.hasOwnProperty(formID) )
            {
                //get the save ttl(registered time+registered ttl value)
                var savedTTL = c_ttl[formID].ttl;
                var savedRAW = c_ttl[formID].raw;

                //get the registered time
                var originalTime = Number(savedTTL - savedRAW);

                //add the temp registered time to current ttl reading
                var nowTTL = Number(originalTime + this.secToMil(ttl));

                //compare if the saved ttl is similar to the nowTTL
                //if so do nothing, otherwise over write the data with new ttl value
                if ( savedTTL === nowTTL )
                {
                    if(window.console && this.debugIsOn) window.console.log('Already attached!! Time set:', c_ttl[formID].ttl, "Time now:", timeNow, "Remaining seconds:", (c_ttl[formID].ttl - timeNow) );
                    return null;
                }
                else
                {
                    if(window.console && this.debugIsOn) window.console.log('Not similar TTL, updating!! Time set:', savedTTL, nowTTL );
                }
            }

            c_ttl[ formID ] = { ttl: timeNow + this.secToMil(ttl), raw: this.secToMil(ttl) };
            if(window.console && this.debugIsOn) window.console.log('Attaching!! Time set:', c_ttl[formID].ttl, "Time now:", timeNow, "Remaining seconds:", (c_ttl[formID].ttl - timeNow) );
            this.saveCurrentTTL(c_ttl);
        },
        getTTLs: function()
        {
            var ttls = JSON.parse( this.get('formsTTL') );
            if ( !ttls ) return null;
            return ttls;
        },
        saveCurrentTTL: function(ttl_arr)
        {
            this.set("formsTTL", JSON.stringify( ttl_arr ) );
        },
        checkAndDestroyTTL: function(curr_ttl)
        {
            var forms_ttl = this.getTTLs();
            var _index = storage.index();
            if ( !forms_ttl ) return null;

            if(window.console && this.debugIsOn) window.console.log("Current formsTTL registered:", forms_ttl );
            for ( var i in forms_ttl )
            {
                var form_ID_name = i;
                var form_ttl_val = forms_ttl[i].ttl;
                var current_time = this.timeNow();
                var formDeleted = false;

                if ( form_ttl_val < current_time )
                {
                    //delete all occurene if this formID to index
                    for( var x in _index )
                    {
                        //if string and the form ID and name is found, remove it - because this is old value
                        if ( typeof _index[x] == "string" && ( _index[x].indexOf(form_ID_name) >= 0 ) )
                        {
                            this.remove(_index[x]);
                            if(window.console && this.debugIsOn) window.console.log('Removed key', _index[x], " of ",form_ID_name );
                            formDeleted = true;
                        }
                    }

                    //if form data is deleted remove it from the formsTTL key
                    if ( formDeleted ) delete forms_ttl[i];

                    this.saveCurrentTTL( forms_ttl );
                }
            }
        },
        flushOldFormData: function()
        {
            if(window.console && this.debugIsOn) window.console.log('Trying to flush old forms..');
            //get all index - registered keys
            var _index = storage.index();
            var _oldForms = [];
            for( var key in _index )
            {
                //if some jotform signature is found
                if ( typeof _index[key] == "string" && ( _index[key].indexOf("jotform_autoFill") >= 0 ) )
                {
                    this.remove(_index[key]);
                    _oldForms.push(_index[key]);
                }
            }

            if ( _oldForms.length > 0 )
            {
                if(window.console && this.debugIsOn) window.console.log("Some old forms are existed: ", _oldForms);
            }
            else
            {
                if(window.console && this.debugIsOn) window.console.log("No old forms detected.");
            }
        }
    };

    AutoFill = function () {
        var params = {
            instantiated: [],
            started: []
        };

        function init(identifier) {
            return {
                setInstanceIdentifier: function (identifier) {
                    this.identifier = identifier
                },
                getInstanceIdentifier: function () {
                    return this.identifier
                },
                setInitialOptions: function (options) {
                    var defaults = {
                        excludeFields: [],
                        customKeyPrefix: "_jF",
                        locationBased: false,
                        allowBindOnChange: true,
                        timeout: 4,
                        ttl: 86400, //1day
                        autoRelease: true,
                        onBeforeSave: function () {},
                        onSave: function () {},
                        onBeforeRestore: function () {},
                        onRestore: function () {},
                        onRelease: function () {}
                    };
                    this.options = this.options || Object.extend(defaults, options);
                    this.jotFormBrowserStorage = jotFormBrowserStorage
                },
                setOptions: function (options) {
                    this.options = this.options || this.setInitialOptions(options);
                    this.options = Object.extend(this.options, options)
                },
                protect: function (targets, options) {
                    var self = this;
                    self.setOptions(options);
                    targets = targets || {};
                    self.stopSaving = false;
                    self.sessionID = options.sessionID;
                    self.targets = self.targets || [];
                    self.href = location.hostname + location.pathname + location.search + location.hash;
                    self.targets = self.targets.concat(targets);
                    if (!self.jotFormBrowserStorage.isAvailable()) return false;
                    var callback_result = self.options.onBeforeRestore.call(self);
                    if (callback_result ===
                        undefined || callback_result) self.restoreAllData();
                    if (self.options.autoRelease) self.bindReleaseData();
                    if (!params.started[self.getInstanceIdentifier()]) {
                        self.bindSaveData();
                        params.started[self.getInstanceIdentifier()] = true
                    }
                },
                bindSaveData: function () {
                    var self = this;
                    if (!self.stopSaving) {
                        if (self.options.timeout) self.saveDataByTimeout();
                        self.targets.forEach(function (target) {
                            var targetFormIdAndName = target.name;
                            var fieldsToProtect = self.getProtectedFields(target);
                            fieldsToProtect.forEach(function (field) {
                                var prefix = (self.options.locationBased ? self.href : "") + targetFormIdAndName + field.name + self.options.customKeyPrefix;
                                if (field.matches('[type="text"], [type="textarea"], [type="date"]')){
                                  if (!self.options.timeout) self.bindSaveDataImmediately(field, prefix);
                                }
                                self.bindSaveDataOnChange(field, prefix)
                            })
                        })
                    }
                },
                getProtectedFields: function(target) {
                    var fields = target.querySelectorAll("input:not([type='submit'],[type='reset'],[type='button'],[type='file'],[type='password'],[name*='cc_'])");
                    this.options.excludeFields.forEach(function(excluded) {
                        fields = fields.filter(function (field){ return field.id !== excluded && field.name !== excluded  } )
                    });
                    return fields;
                },
                saveAllData: function () {

                    if(!JotForm.autoFillDeployed) return; //don't let the change event trigger save until setup has finished

                    var self = this;
                    if (typeof self.options.onBeforeSave === 'function') self.options.onBeforeSave.call(self);
                    if (!self.stopSaving) {
                        self.savedData = {};
                        self.targets.forEach(function (target,index) {
                            var targetFormIdAndName = target.name;
                            var fieldsToProtect = self.getProtectedFields(target);
                            self.savedData[index] = {
                                protectedfields: fieldsToProtect,
                                protectedfieldsdata: {}
                            };
                            if ( self.options.ttl ) jotFormBrowserStorage.setTTL(targetFormIdAndName, self.options.ttl);
                            fieldsToProtect.forEach(function (field,index2) {
                                var fieldIdAndName = field.id + field.name;
                                var prefix = self.getKeyName(targetFormIdAndName, field.id, field.name);
                                var value = field.value;
                                self.savedData[index].protectedfieldsdata[index2] = {
                                    field: field,
                                    fieldid: fieldIdAndName,
                                    prefix: prefix,
                                    value: value
                                };
                                if (field.matches('[type="checkbox"]')) {
                                    if (field.name.indexOf("[") !== -1) {
                                        value = [];
                                        document.querySelectorAll("[name='" + field.name + "']:checked").forEach(function (el) {
                                            value.push(el.value)
                                        })
                                    } else value =
                                        field.matches(":checked");
                                    self.saveTojotFormBrowserStorage(prefix, value, false)
                                } else if (field.matches('[type="radio"]')) {
                                    if (field.matches(":checked")) {
                                        value = field.value;
                                        self.saveTojotFormBrowserStorage(prefix, value, false)
                                    } else {
                                        self.jotFormBrowserStorage.remove(prefix);
                                    }
                                } else self.saveTojotFormBrowserStorage(prefix, value, false)
                            });
                        });
                        if (typeof self.options.onSave === 'function') self.options.onSave.call(self)
                    }
                },
                restoreAllData: function () {
                    var self = this;
                    var restored = false;
                    if (typeof self.options.onBeforeRestore === 'function') self.options.onBeforeRestore.call(self);

                    //flush data from old autofill forms - temporary
                    jotFormBrowserStorage.flushOldFormData();

                    //kill TTLs first that is assigned to data form
                    if ( self.options.ttl ) jotFormBrowserStorage.checkAndDestroyTTL(self.options.ttl);

                    self.restoredData = {};
                    self.targets.forEach(function (target,index) {
                        var targetFormIdAndName = target.name;
                        var fieldsToProtect = self.getProtectedFields(target);
                        self.restoredData[index] = {
                            protectedfields: fieldsToProtect,
                            protectedfieldsdata: {}
                        };
                        fieldsToProtect.forEach(function (field,index2) {
                            var prefix = self.getKeyName(targetFormIdAndName, field.id, field.name);
                            var resque = self.jotFormBrowserStorage.get(prefix);
                            if (resque) {
                                if(field.id === 'session' && JotForm.sessionID) {
                                    resque = JotForm.sessionID;
                                    self.saveTojotFormBrowserStorage(prefix, JotForm.sessionID, false);
                                }
                                self.restoreFieldsData(field, resque);
                                restored = true
                            }
                            self.restoredData[index].protectedfieldsdata[index2] = {
                                field: field,
                                prefix: prefix,
                                newinputvalue: resque
                            }
                        });
                    });
                    if (restored && window.FORM_MODE === 'cardform') {
                       window.CardForm.checkCardsIfFilled(window.CardForm.cards);
                       window.CardForm.dropdown.setInitialValues();
                    }
                    if (restored && typeof self.options.onRestore === 'function') self.options.onRestore.call(self)
                },
                restoreFieldsData: function (field, resque) {
                    if (field.matches('[type="checkbox"]') && resque !== "false" && field.name.indexOf("[") === -1){
                        field.setAttribute("checked", "checked");
                    }
                    else if (field.matches('[type="checkbox"]') && resque === "false" && field.name.indexOf("[") === -1) {
                        field.removeAttribute("checked");
                    }
                    else if (field.matches('[type="radio"]')) {
                        if (field.value === resque) field.setAttribute("checked", "checked")
                    } else if (field.name && field.name.indexOf("[") === -1) {
                        field.value = resque;
                    } else if (field.matches('[type="checkbox"]')) {
                        if(resque.indexOf(field.value) > -1) {
                            field.setAttribute("checked", "checked");
                        }
                    } else {
                        resque = field.length > 1 && resque.indexOf(',') > -1 ? resque.split(",") : resque;
                        field.value = resque;
                    }
                },
                bindSaveDataImmediately: function (field, prefix) {
                    var self = this;
                    if (!self.stopSaving)
                        if ("onpropertychange" in
                            field) field.get(0).onpropertychange = function () {
                            self.saveTojotFormBrowserStorage(prefix, field.value)
                        };
                        else field.get(0).oninput = function () {
                            self.saveTojotFormBrowserStorage(prefix, field.value)
                        }
                },
                saveTojotFormBrowserStorage: function (key, value, fireCallback) {
                    var self = this;
                    if (!self.stopSaving) {
                        fireCallback = fireCallback === undefined ? true : fireCallback;
                        this.jotFormBrowserStorage.set(key, value);
                        if (fireCallback && value !== "" && typeof this.options.onSave === 'function') this.options.onSave.call(self)
                    }
                },
                bindSaveDataOnChange: function (field, prefix) {
                    var self = this;
                    if ( self.options.allowBindOnChange )
                    {
                        if (!self.stopSaving) {
                            field.addEventListener('change',function () {
                                self.saveAllData();
                            });
                        }
                    }
                },
                saveDataByTimeout: function () {
                    var self = this;
                    if (!self.stopSaving) {
                        var targetForms = self.targets;
                        setTimeout(function (targetForms) {
                            function timeout() {
                                self.saveAllData();
                                setTimeout(timeout, self.options.timeout * 1E3)
                            }
                            return timeout
                        }(targetForms), self.options.timeout * 1E3)
                    }
                },
                bindReleaseData: function () {
                    var self = this;
                    self.targets.forEach(function (target) {
                        var fieldsToProtect = self.getProtectedFields(target);
                        var formIdAndName = target.id + target.name;
                        target.addEventListener('submit', function () {
                            self.releaseData(formIdAndName, fieldsToProtect)
                        });
                        target.addEventListener('reset', function () {
                            self.releaseData(formIdAndName, fieldsToProtect, true)
                        });
                    })
                },
                manuallyReleaseData: function (clearFields) {
                    var self = this;
                    self.stopSavingData();
                    self.targets.forEach(function (target,i) {
                        var fieldsToProtect = self.getProtectedFields(target);
                        var formIdAndName = target.id + target.name;
                        self.releaseData(formIdAndName, fieldsToProtect, clearFields);
                    })
                },
                stopSavingData: function () {
                    var self = this;
                    self.stopSaving = true
                },
                releaseData: function (targetFormIdAndName, fieldsToProtect, clearfields) {
                    var released = false;
                    var self = this;
                    fieldsToProtect.forEach(function (field) {
                        if (clearfields) {
                            if (field.matches('[type="radio"], [type="checkbox"]')) {
                                field.checked = false;
                                field.removeAttribute("checked");
                            }
                        }
                        
                        var prefix = self.getKeyName(targetFormIdAndName, field.id, field.name);
                        self.jotFormBrowserStorage.remove(prefix);
                        released = true
                    });
                    if (released && typeof self.options.onRelease === 'function') self.options.onRelease.call(self)
                },
                getKeyName: function(formName, fieldId, fieldName) {
                    return (this.options.locationBased ? this.href : "") + formName + fieldId + fieldName + this.options.customKeyPrefix;
                }
            }
        }
        return {
            getInstance: function (identifier) {
                if (!params.instantiated[identifier]) {
                    params.instantiated[identifier] = init();
                    params.instantiated[identifier].setInstanceIdentifier(identifier);
                    params.instantiated[identifier].setInitialOptions()
                }
                if (identifier) return params.instantiated[identifier];
                return params.instantiated[identifier]
            },
            free: function () {
                params = {};
                return null
            }
        }
    }()
})();
