<?php
session_start();
require_once 'config/db2.php'; // Include your database configuration file

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST['email']);
    $new_password = trim($_POST['new_password']);
    $confirm_password = trim($_POST['confirm_password']);

    // Validate email
    if (empty($email)) {
        $response = array("success" => false, "message" => "Please enter your email.");
        echo json_encode($response);
        exit;
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $response = array("success" => false, "message" => "Invalid email format.");
        echo json_encode($response);
        exit;
    }

    // Validate passwords
    if (empty($new_password) || empty($confirm_password)) {
        $response = array("success" => false, "message" => "Please enter and confirm your new password.");
        echo json_encode($response);
        exit;
    } elseif ($new_password !== $confirm_password) {
        $response = array("success" => false, "message" => "Passwords do not match.");
        echo json_encode($response);
        exit;
    }

    // Check if email exists in the database
    $sql = "SELECT id FROM admintndii WHERE email = ?";
    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows == 1) {
            // Update the user's password
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            $update_sql = "UPDATE admintndii SET password = ? WHERE email = ?";
            if ($update_stmt = $conn->prepare($update_sql)) {
                $update_stmt->bind_param("ss", $hashed_password, $email);
                if ($update_stmt->execute()) {
                    $response = array("success" => true, "message" => "Password has been successfully updated.");
                } else {
                    $response = array("success" => false, "message" => "Something went wrong. Please try again later.");
                }
            }
        } else {
            $response = array("success" => false, "message" => "No account found with that email.");
        }
    } else {
        $response = array("success" => false, "message" => "Database error. Please try again later.");
    }

    echo json_encode($response);
}
?>
