<?php
session_start();

require 'config/db2.php'; // Ensure this path is correct


$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}


$user_role = $_SESSION['user_role'];
$district = $_SESSION['district'];


// Initialize variables for query results
$pending = $verified = $declined = $approved = [];
$total = 0;



// Append district filter for users (non-admin roles)
if ($user_role == 'User') {
    $sql_total = "SELECT COUNT(*) AS total FROM application_form WHERE communication_city = '$district'";
    $sql_pending = "SELECT COUNT(*) AS pending FROM application_form WHERE statusapp = 'Document_uploaded' AND communication_city = '$district'";
    $sql_verified = "SELECT COUNT(*) AS verified FROM application_form WHERE statusapp = 'Verified' AND communication_city = '$district'";
    $sql_declined = "SELECT COUNT(*) AS declined FROM application_form WHERE statusapp = 'Reject' AND communication_city = '$district'";
    $sql_approved = "SELECT COUNT(*) AS approved FROM application_form WHERE statusapp = 'Approved' AND communication_city = '$district'";
}
else {
    
    // Base SQL queries
$sql_total = "SELECT COUNT(*) AS total FROM application_form";
$sql_pending = "SELECT COUNT(*) AS pending FROM application_form WHERE statusapp = 'Document_uploaded'";
$sql_verified = "SELECT COUNT(*) AS verified FROM application_form WHERE statusapp = 'Verified'";
$sql_declined = "SELECT COUNT(*) AS declined FROM application_form WHERE statusapp = 'Reject'";
$sql_approved = "SELECT COUNT(*) AS approved FROM application_form WHERE statusapp = 'Approved'";
}

$result_total = $conn->query($sql_total);
$result_pending = $conn->query($sql_pending);
$result_verified = $conn->query($sql_verified);
$result_declined = $conn->query($sql_declined);
$result_approved = $conn->query($sql_approved);

$pending = $result_pending->fetch_assoc();
$verified = $result_verified->fetch_assoc();
$declined = $result_declined->fetch_assoc();
$approved = $result_approved->fetch_assoc();
$total = $pending['pending'] + $verified['verified'] + $declined['declined'] + $approved['approved'];



$chartData = [
    'labels' => ['Verified','Pending', 'Declined', 'Approved'],
    'data' => [
        $verified['verified'],
        $pending['pending'],
        $declined['declined'],
        $approved['approved']
    ],
    'backgroundColor' => [
        'rgb(255, 79, 138)',
        'rgb(54, 162, 235)',
        'rgb(255, 205, 86)',
        'rgb(75, 192, 192)'
    ]
];

$jsonChartData = json_encode($chartData);


// Adjust SQL query for application list based on role
if ($user_role == "User") {
    $sql_gender = "SELECT gender, COUNT(*) as count FROM application_form WHERE gender IN ('Male', 'Female') AND communication_city = '$district' GROUP BY gender";
    
} else {
       $sql_gender = "SELECT gender, COUNT(*) as count FROM application_form WHERE gender IN ('Male', 'Female') GROUP BY gender";

}


// Query to get gender distribution excluding null or empty values
$result_gender = $conn->query($sql_gender);

// Prepare gender data for Chart.js
$genderData = [];
while ($row = $result_gender->fetch_assoc()) {
    $genderData[$row['gender']] = $row['count'];
}

// Ensure we have both 'Male' and 'Female' in the dataset even if one of them has zero count
if (!isset($genderData['Male'])) {
    $genderData['Male'] = 0;
}
if (!isset($genderData['Female'])) {
    $genderData['Female'] = 0;
}

$genderChartData = [
    'labels' => array_keys($genderData),
    'data' => array_values($genderData),
    'backgroundColor' => [
        'rgb(54, 162, 235)', // Color for Male
        'rgb(255, 99, 132)'  // Color for Female
    ]
];

$jsonGenderChartData = json_encode($genderChartData);


// Adjust SQL query for application list based on role
if ($user_role == "User") {
    $sql_caste = "SELECT caste, COUNT(*) as count FROM application_form WHERE communication_city = '$district' AND caste IS NOT NULL AND caste != '' GROUP BY caste";

} else {
        $sql_caste = "SELECT caste, COUNT(*) as count FROM application_form WHERE caste IS NOT NULL AND caste != '' GROUP BY caste";

}
// Query to get caste distribution excluding null values
$result_caste = $conn->query($sql_caste);

// Prepare caste data for Chart.js
$casteData = [];
while ($row = $result_caste->fetch_assoc()) {
    $casteData[strtolower($row['caste'])] = $row['count'];
}

// Ensure only the specified caste categories are present
$casteCategories = ['general', 'obc', 'sc', 'st','mbc','others'];
$filteredCasteData = [];
foreach ($casteCategories as $caste) {
    $filteredCasteData[$caste] = isset($casteData[$caste]) ? $casteData[$caste] : 0;
}

$casteChartData = [
    'labels' => array_map('strtoupper', array_keys($filteredCasteData)), // Capitalize the first letter of each label
    'data' => array_values($filteredCasteData),
    'backgroundColor' => [
        'rgb(75, 192, 192)',
        'rgb(255, 159, 64)',
        'rgb(153, 102, 255)',
        'rgb(255, 205, 86)',
        'rgb(54, 162, 235)',
        'rgb(201, 203, 207)'
    ]
];

$jsonCasteChartData = json_encode($casteChartData);

if ($user_role == "User") {
    $sql = "SELECT * FROM application_form WHERE communication_city = '$district' AND statusapp IN ('Document_uploaded', 'Approved', 'Reject','Verified') ORDER BY app_no DESC";


} else {
        $sql = "SELECT * FROM application_form WHERE statusapp IN ('Document_uploaded', 'Approved', 'Reject','Verified') ORDER BY app_no DESC";


}

$result = $conn->query($sql);

// Close the connection
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>TNEDII - ADMIN</title>
        <link href="https://cdn.datatables.net/v/dt/dt-2.0.7/datatables.min.css" rel="stylesheet">
        <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.2.3/css/buttons.dataTables.min.css">
        <link href="css/styles.css" rel="stylesheet" />
        <link href="css/view.css" rel="stylesheet" />
        <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" rel="stylesheet">

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.9/css/buttons.dataTables.min.css">
        <link href="https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400..700;1,400..700&family=Nunito:ital,wght@0,200..1000;1,200..1000&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
        <script src="https://use.fontawesome.com/releases/v6.3.0/js/all.js" crossorigin="anonymous"></script>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
        <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
                <script>    // Prevent back navigation after logout
            if (window.history && window.history.pushState) {
                window.history.pushState(null, null, window.location.href);
                window.onpopstate = function () {
                    window.history.pushState(null, null, window.location.href);
                };
            }</script>
            <script src="https://kit.fontawesome.com/5164f520d9.js" crossorigin="anonymous"></script>

<style>
.navbar-dark .navbar-brand {
    background: whitesmoke;
    color: #000;
}
.navbar-dark .navbar-brand:hover {
    background: whitesmoke;
    color: #000;
}

.navbar-dark .navbar-nav .nav-link{
    color: gray;
}
.navbar-dark .navbar-nav .nav-link:hover{
    color: gray;
}
.navbar-dark .navbar-nav .nav-link:focus{
    color:gray;
}
  
        .container {
            background-color: white;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .container .form-group label {
            font-weight: bold;
        }

        .container .form-group p {
            margin-bottom: 0;
        }
        .form-check-input{
            margin-left: 20px;
            border: 1px solid black;
            box-shadow: rgba(100, 100, 111, 0.2) 0px 7px 29px 0px;
        }
        .container .img-fluid {
            max-width: 100px;
            height: auto;
            border-radius: 8px;
            margin-top: 10px;
        }

        .embed-responsive {
            position: relative;
            display: block;
            width: 100%;
            padding: 0;
            overflow: hidden;
        }

        .embed-responsive::before {
            display: block;
            content: "";
        }

        .embed-responsive-16by9::before {
            padding-top: 56.25%;
        }

        .embed-responsive-item {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 0;
        }
        .cardchart{
            height: 500px;
        }
   .dropdown{
       margin-right: 30px;
   }
   .filter-container {
    padding: 20px;
    display: flex;
    align-items: flex-start;
    margin-bottom: 15px;
    flex-direction: row;
    flex-wrap: nowrap;
    align-content: center;
    justify-content: space-between;
}

@media only screen and (max-width: 768px) {
      .filter-container {
           flex-wrap: wrap;
          
      }
}

        .filter-container label {
            margin-right: 10px;
            font-weight: bold;
        }
        .filter-container select {
            position: relative;
            margin-right: 20px;
            padding: 5px 10px;
            border-radius: 5px;
            border: 1px solid #ccc;
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background: none;
            padding-right: 30px;
        }
        .filter-container select::after {
            content: '\f078';
            font-family: 'Font Awesome 5 Free';
            font-weight: 900;
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            pointer-events: none;
        }
        .filter-container select.active::after {
            transform: translateY(-50%) rotate(180deg);
        }
        .custom-select-wrapper {
            width: 200px;
            margin-right: 10px;
            position: relative;
        }
        .custom-select-wrapper::after {
            content: '\f0d7';
            font-family: 'Font Awesome 5 Free';
            font-weight: 900;
            position: absolute;
            right: 10px;
            top: 50%;
            transform: translateY(-50%);
            pointer-events: none;
            transition: transform 0.3s ease;
        }
        .custom-select-wrapper.active::after {
            transform: translateY(-50%) rotate(180deg);
        }
        .cont{
            padding: 18px;
        }
         th:nth-child(6), td:nth-child(6) {
            display: none;
        }
          th:nth-child(7), td:nth-child(7) {
            display: none;
        }
          th:nth-child(8), td:nth-child(8) {
            display: none;
        }
          th:nth-child(9), td:nth-child(9) {
            display: none;
        }
        .sb-topnav {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.dataTables_filter{
    outline: none;
    display: flex;
    justify-content: flex-end;
}
 label[for="dataTables_filter"] {
        margin-right: 10px; /* Adjust the margin as needed */
    }

    </style>

    </head>
    <body class="sb-nav-fixed">
       <nav class="sb-topnav navbar navbar-expand navbar-dark">
             <a class="logotxt" href="index.html">EDII-TN</a>
            <!-- Sidebar Toggle-->
              <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!"><i class="fas fa-bars"></i></button>
      
            <div class="logotn"> <img src="images/adminlogo1.png" alt="" srcset=""></div>
            <div class="logotn1"> <img src="images/logo1.png" alt="" srcset=""></div>
             <!-- Navbar-->
            <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-user fa-fw"></i></a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <li><a class="dropdown-item" href="#!">Settings</a></li>
                        <li><a class="dropdown-item" href="#!">Activity Log</a></li>
                            <li><a class="dropdown-item" href="forget.php">Reset Password</a></li>
                        <li><hr class="dropdown-divider" /></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
           
        </nav>
        <div id="layoutSidenav">
           <div id="layoutSidenav_nav">
                <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                    <div class="sb-sidenav-menu">
                        <div class="nav">
                            <div class="sb-sidenav-menu-heading"><?php echo ($user_role == 'User') ? " - $district ADMIN"  : ''; ?></div>
                            <a class="nav-link" href="dash.php">
                                <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                                Dashboard
                            </a>
                            <div class="sb-sidenav-menu-heading">Application</div>
                            <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#collapseLayouts" aria-expanded="false" aria-controls="collapseLayouts">
                                <div class="sb-nav-link-icon"><i class="fas fa-columns"></i></div>
                                Actions
                                <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                            </a>
                          <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                       <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="action.php">Take Action</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                            <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                     <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                       <a class="nav-link" href="entry.php">Entry List</a>
                                        <?php endif; ?>
                                </nav>
                            </div>
                           
                             <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                      <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="verified.php">Pending Application</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                        
                             <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                      <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="reject.php">Rejected Application</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                            <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                      <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="approve.php">Approved Application</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                             <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                    <a class="nav-link" href="report.php">Report</a>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                              
                            <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                            <nav class="sb-sidenav-menu-nested nav">
                                                  <?php if ($user_role == "SuperAdmin") { ?>
                                                <a class="nav-link" href="invite.php">Invite Reapplicants</a>
                                                 <?php } ?>
                                                <!-- Add other menu items here if needed -->
                                            </nav>
                            </div>
                                   
                                   

                            <div class="collapse" id="collapsePages" aria-labelledby="headingTwo" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav accordion" id="sidenavAccordionPages">
                                    <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#pagesCollapseAuth" aria-expanded="false" aria-controls="pagesCollapseAuth">
                                        Authentication
                                        <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                                    </a>
                                    <div class="collapse" id="pagesCollapseAuth" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordionPages">
                                        <nav class="sb-sidenav-menu-nested nav">
                                            <a class="nav-link" href="login.html">Login</a>
                                            <a class="nav-link" href="register.html">Register</a>
                                            <a class="nav-link" href="password.html">Forgot Password</a>
                                        </nav>
                                    </div>
                                    <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#pagesCollapseError" aria-expanded="false" aria-controls="pagesCollapseError">
                                        Error
                                        <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                                    </a>
                                    <div class="collapse" id="pagesCollapseError" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordionPages">
                                        <nav class="sb-sidenav-menu-nested nav">
                                            <a class="nav-link" href="401.html">401 Page</a>
                                            <a class="nav-link" href="404.html">404 Page</a>
                                            <a class="nav-link" href="500.html">500 Page</a>
                                        </nav>
                                    </div>
                                </nav>
                            </div>
                           
                        </div>
                    </div>
                    <div class="sb-sidenav-footer">
                        <div class="small">Logged in as:</div>
                        EDII-TN <?php echo $user_role ?>
                    </div>
                </nav>
            </div>
            <div id="layoutSidenav_content">
                <main>
                    
                    <div class="container-fluid px-4">
                        <h5 class="mt-4">Report Board</h5>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item active">Report </li>
                        </ol>
                        <div class="cont">
                        <div class="row">
                          <div class="card col-md-4 mb-4">
                                <div class="card-header">
                                    <i class="fas fa-chart-pie me-1"></i>
                                    Application Status
                                </div>
                                <div class="card-body">
                                    <canvas id="statusChart"  width="100" height="380"></canvas>
                                </div>
                            </div>
                             <div class="card col-md-4 mb-4">
                                <div class="card-header">
                                    <i class="fas fa-chart-pie me-1"></i>
                                   Gender Chart
                                </div>
                                <div class="card-body">
                                    <canvas id="genderChart"  width="100" height="160"></canvas>
                                </div>
                            </div>
                             <div class="card col-md-4 mb-4">
                                <div class="card-header">
                                    <i class="fas fa-chart-pie me-1"></i>
                                    Caste Wise Chart
                                </div>
                                <div class="card-body">
                                    <canvas id="casteChart"  width="100" height="160"></canvas>
                                </div>
                            </div>
                          
                         
                           </div></div>
                
                       
                                        
                     
                            <div class="card mb-4">
   <div class="filter-container">
        <label for="districtFilter">District:</label>
        <div class="custom-select-wrapper">
            <select id="districtFilter" class="custom-select">
                <option value="">All</option>
                <option value="Ariyalur">Ariyalur</option>
                <option value="Chengalpattu">Chengalpattu</option>
                <option value="Chennai">Chennai</option>
                <option value="Coimbatore">Coimbatore</option>
                <option value="Cuddalore">Cuddalore</option>
                <option value="Dharmapuri">Dharmapuri</option>
                <option value="Dindigul">Dindigul</option>
                <option value="Erode">Erode</option>
                <option value="Kallakurichi">Kallakurichi</option>
                <option value="Kancheepuram">Kancheepuram</option>
                <option value="Karur">Karur</option>
                <option value="Krishnagiri">Krishnagiri</option>
                <option value="Madurai">Madurai</option>
                <option value="Nagapattinam">Nagapattinam</option>
                <option value="Namakkal">Namakkal</option>
                <option value="Nilgiris">Nilgiris</option>
                <option value="Perambalur">Perambalur</option>
                <option value="Pudukkottai">Pudukkottai</option>
                <option value="Ramanathapuram">Ramanathapuram</option>
                <option value="Ranipet">Ranipet</option>
                <option value="Salem">Salem</option>
                <option value="Sivaganga">Sivaganga</option>
                <option value="Tenkasi">Tenkasi</option>
                <option value="Thanjavur">Thanjavur</option>
                <option value="Theni">Theni</option>
                <option value="Thoothukudi">Thoothukudi</option>
                <option value="Tiruchirappalli">Tiruchirappalli</option>
                <option value="Tirunelveli">Tirunelveli</option>
                <option value="Tirupathur">Tirupathur</option>
                <option value="Tiruppur">Tiruppur</option>
                <option value="Tiruvallur">Tiruvallur</option>
                <option value="Tiruvannamalai">Tiruvannamalai</option>
                <option value="Thiruvarur">Tiruvarur</option>
                <option value="Vellore">Vellore</option>
                <option value="Viluppuram">Viluppuram</option>
                <option value="Virudhunagar">Virudhunagar</option>
            </select>
        </div>

        <label for="fieldFilter">Field:</label>
        <div class="custom-select-wrapper">
            <select id="fieldFilter" class="custom-select">
                <option value="">All</option>
                <option value="Engineering">Engineering</option>
                <option value="Arts & Science (Arts stream)">Arts & Science (Arts stream)</option>
                <option value="Arts & Science (Science stream)">Arts & Science (Science stream)</option>
                <option value="Arts and Science (Commerce)">Arts and Science (Commerce)</option>
                <option value="Agriculture">Agriculture</option>
                <option value="Fisheries">Fisheries</option>
                <option value="Veterinary">Veterinary</option>
                <option value="Medicine (Allopathy, Ayurvedic, Siddha, Homeopathy)">Medicine (Allopathy, Ayurvedic, Siddha, Homeopathy)</option>
                <option value="Nursing/Paramedical">Nursing/Paramedical</option>
                <option value="Law">Law</option>
                <option value="Dental/Ophthalmology/Psychotherapy/Pharmacy">Dental/Ophthalmology/Psychotherapy/Pharmacy</option>
                <option value="Others">Others</option>
            </select>
        </div>
        
         <label for="statusFilter">Status:</label>
             <div class="custom-select-wrapper">
        <select id="statusFilter" class="custom-select">
            <option value="">All</option>
            <option value="Approved">Approved</option>
            <option value="Reject">Reject</option>
            <option value="Document_uploaded">Pending</option>
        </select>
        </div>

        <label for="casteFilter">Caste:</label>
            <div class="custom-select-wrapper">
        <select id="casteFilter" class="custom-select">
            <option value="">All</option>
            <option value="General">General</option>
            <option value="OBC">OBC</option>
            <option value="MBC">MBC</option>
            <option value="SC">SC</option>
            <option value="ST">ST</option>
            <option value="Others">Others</option>
        </select>
        </div>
           <button id="resetFilters" class="btn btn-secondary">Reset</button>
           
    </div>
 
                          
                          <div class="card-body">
                              
    <div class="table-responsive">
                  <div class="d-flex justify-content-end mb-2">
                <?php if ($user_role == "User") { ?>
                    <div></div>
                <?php } else { ?>
                    <button type="button" class="btn btn-info" id="districtSummaryButton" data-bs-toggle="modal" data-bs-target="#districtSummaryModal">View District Summary</button>
                <?php } ?>
            </div>

        <table class="table table-bordered" id="datatablesSimple" width="100%" cellspacing="0">
            
            <thead>
                <tr>
                     <th>Application Date</th>
                    <th>Application Number</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                     <th style="width: 120px;">Date of Birth</th> 
                    <th>Gender</th>
                    <th>Email</th>
                    <th>Mobile</th>
                    <th>Caste</th>
                    <th>Religion</th>
                    <th>Nationality</th>
                    <th>Program</th>
                    <th>Qualification</th>
                    <th>University</th>
                    <th>Degree Name</th>
                    <th>Graduation Year</th>
                    <th>Percentage</th>
                    <th>Field</th>
                    <th>Differently Abled</th>
                    <th>Marital Status</th>
                    <th>Father's Name</th>
                    <th>Father's Occupation</th>
                    <th>Father's Annual Income</th>
                    <th>Father's Mobile</th>
                    <th>Mother's Name</th>
                    <th>Mother's Occupation</th>
                    <th>Mother's Annual Income</th>
                    <th>Mother's Mobile Number</th>
                    <th>Permanent Street Address 1</th>
                    <th>Permanent Street Address 2</th>
                    <th>Permanent City</th>
                    <th>Permanent State</th>
                    <th>Permanent Postal Code</th>
                    <th>Communication Street Address 1</th>
                    <th>Communication Street Address 2</th>
                    <th>Communication City</th>
                    <th>Communication State</th>
                    <th>Communication Postal Code</th>
                    <th>Status</th>
                    <th>Remark</th>
                    <th>View</th> <!-- New column for the Modal trigger button -->
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<td>" . $row["application_date"] . "</td>";
                        echo "<td>" . $row["app_no"] . "</td>";
                        echo "<td>" . $row["first_name"] . "</td>";
                        echo "<td>" . $row["last_name"] . "</td>";
                        echo "<td>" . $row["date_of_birth"] . "</td>";
                        echo "<td>" . $row["gender"] . "</td>";
                        echo "<td>" . $row["email"] . "</td>";
                        echo "<td>" . $row["mobile"] . "</td>";
                        echo "<td>" . $row["caste"] . "</td>";
                        echo "<td>" . $row["religion"] . "</td>";
                        echo "<td>" . $row["nationality"] . "</td>";
                        echo "<td>" . $row["program"] . "</td>";
                        echo "<td>" . $row["qualification"] . "</td>";
                        echo "<td>" . $row["university"] . "</td>";
                        echo "<td>" . $row["degree_name"] . "</td>";
                        echo "<td>" . $row["graduation_year"] . "</td>";
                        echo "<td>" . $row["percentage"] . "</td>";
                        echo "<td>" . $row["field"] . "</td>";
                        echo "<td>" . $row["differently_abled"] . "</td>";
                        echo "<td>" . $row["marital_status"] . "</td>";
                        echo "<td>" . $row["fathers_name"] . "</td>";
                        echo "<td>" . $row["father_occupation"] . "</td>";
                        echo "<td>" . $row["fathers_annual_income"] . "</td>";
                        echo "<td>" . $row["fathers_mobile"] . "</td>";
                        echo "<td>" . $row["mothers_name"] . "</td>";
                        echo "<td>" . $row["mother_occupation"] . "</td>";
                        echo "<td>" . $row["mothers_annual_income"] . "</td>";
                        echo "<td>" . $row["mothers_mobile_number"] . "</td>";
                        echo "<td>" . $row["permanent_street_address1"] . "</td>";
                        echo "<td>" . $row["permanent_street_address2"] . "</td>";
                        echo "<td>" . $row["permanent_city"] . "</td>";
                        echo "<td>" . $row["permanent_state"] . "</td>";
                        echo "<td>" . $row["permanent_postal_code"] . "</td>";
                        echo "<td>" . $row["communication_street_address1"] . "</td>";
                        echo "<td>" . $row["communication_street_address2"] . "</td>";
                        echo "<td>" . $row["communication_city"] . "</td>";
                        echo "<td>" . $row["communication_state"] . "</td>";
                        echo "<td>" . $row["communication_postal_code"] . "</td>";
                        echo "<td>" . $row["statusapp"] . "</td>";
                        echo "<td>" . $row["remark"] . "</td>";

                        // Add a button to trigger the modal
                        echo "<td><button type='button' class='btn btn-primary' data-bs-toggle='modal' data-bs-target='#staticBackdrop' data-appno='" . $row["app_no"] . "'>View</button></td>";

                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='44'>No data available</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

    
    <div class="modal fade" id="districtSummaryModal" tabindex="-1" aria-labelledby="districtSummaryModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="districtSummaryModalLabel">District Summary</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>District</th>
                            <th>Approved</th>
                            <th>Pending</th>
                            <th>Verified</th>
                        </tr>
                    </thead>
                    <tbody id="districtSummaryTableBody">
                        <!-- Dynamic Content -->
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


                 <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h1 class="modal-title fs-5" id="staticBackdropLabel">View Application</h1>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                           
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                             
                            </div>
                        </div>
                    </div>
                </div>
                            <!-- Modal -->






                        </div>
                    </div>
                </main>
               
            </div>
        </div>
        
        
 <?php if ($user_role == "User") { ?>      
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Status Chart
        const ctx = document.getElementById('statusChart').getContext('2d');
        const chartData = <?php echo $jsonChartData; ?>;
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: chartData.labels,
                datasets: [{
                    label: 'Application Status',
                    data: chartData.data,
                    backgroundColor: chartData.backgroundColor,
                    hoverOffset: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });

        // Gender Chart
        const genderCtx = document.getElementById('genderChart').getContext('2d');
        const genderChartData = <?php echo $jsonGenderChartData; ?>;
        new Chart(genderCtx, {
            type: 'doughnut',
            data: {
                labels: genderChartData.labels,
                datasets: [{
                    label: 'Gender Distribution',
                    data: genderChartData.data,
                    backgroundColor: genderChartData.backgroundColor,
                    hoverOffset: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
        
        // Caste Chart
        const casteCtx = document.getElementById('casteChart').getContext('2d');
        const casteChartData = <?php echo $jsonCasteChartData; ?>;
        new Chart(casteCtx, {
            type: 'doughnut',
            data: {
                labels: casteChartData.labels,
                datasets: [{
                    label: 'Caste Distribution',
                    data: casteChartData.data,
                    backgroundColor: casteChartData.backgroundColor,
                    hoverOffset: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
    });
    
    

    document.addEventListener('DOMContentLoaded', function () {
        // Initialize DataTables with the lengthMenu option and buttons for export
        const dataTable = $('#datatablesSimple').DataTable({
            "lengthMenu": [10, 25, 50, 100, 200],
            "columnDefs": [
                { "width": "150px", "targets": 4 } // Adjusting the width of the fifth column (index 4)
            ],
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'pdfHtml5',
                    text: 'Export PDF',
                    orientation: 'landscape',
                    pageSize: 'A3',
                    title: '',
                    filename: 'TNEDII_PG_DIP_2024-25',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude the last column (View)
                    },
                    customize: function (doc) {
                        // Add custom header to the PDF document
                        doc.content.splice(0, 0, {
                            text: 'TNEDII_PG Diploma Entrepreneurship & Innovation 2024 - 25',
                            margin: [0, 0, 0, 2],
                            alignment: 'center',
                            fontSize: 8
                        });

                        // Customize the PDF document if needed
                        doc.defaultStyle.fontSize = 3;
                        doc.styles.tableHeader.fontSize = 4;
                        doc.styles.tableHeader.alignment = 'center';

                        // Extract data for the table
                        var tableData = [];
                        $('#datatablesSimple tbody tr').each(function () {
                            var district = $(this).find('td:eq(32)').text(); // Communication City (District)
                            var statusApproved = $(this).find('td:eq(37)').text(); // Approved
                            var statusPending = $(this).find('td:eq(37)').text(); // Document_uploaded
                            var statusVerified = $(this).find('td:eq(37)').text(); // Verified
                            tableData.push([district, statusApproved, statusPending, statusVerified]);
                        });
                    }
                },
                {
                    extend: 'csvHtml5',
                    text: 'Export CSV',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude the last column (View) only for CSV export
                    }
                }
            ]
        });

        function filterTable() {
            const districtValue = document.getElementById('districtFilter').value.toLowerCase();
            const fieldValue = document.getElementById('fieldFilter').value.toLowerCase();
            const statusValue = document.getElementById('statusFilter').value.toLowerCase();
            const casteValue = document.getElementById('casteFilter').value.toLowerCase();

            $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
                const district = data[35].toLowerCase(); // Communication City (District)
                const field = data[17].toLowerCase(); // Field
                const status = data[38].toLowerCase(); // Status
                const caste = data[8].toLowerCase(); // Caste

                const districtMatch = !districtValue || district.includes(districtValue);
                const fieldMatch = !fieldValue || field.includes(fieldValue);
                const statusMatch = !statusValue || status.includes(statusValue);
                const casteMatch = !casteValue || caste.includes(casteValue);

                return districtMatch && fieldMatch && statusMatch && casteMatch;
            });

            // Check if any filter is applied
            const isAnyFilterApplied = districtValue || fieldValue || statusValue || casteValue;

            // Set the page length to 1000 if any filter is applied, otherwise reset to default (4)
            dataTable.page.len(isAnyFilterApplied ? 1000 : 4).draw();

            $.fn.dataTable.ext.search.pop();
        }

        document.getElementById('districtFilter').addEventListener('change', filterTable);
        document.getElementById('fieldFilter').addEventListener('change', filterTable);
        document.getElementById('statusFilter').addEventListener('change', filterTable);
        document.getElementById('casteFilter').addEventListener('change', filterTable);
        document.getElementById('resetFilters').addEventListener('click', function () {
            document.getElementById('districtFilter').value = '';
            document.getElementById('fieldFilter').value = '';
            document.getElementById('statusFilter').value = '';
            document.getElementById('casteFilter').value = '';
            filterTable();
        });
    });
    </script>
<?php } else { ?>  


    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Status Chart
        const ctx = document.getElementById('statusChart').getContext('2d');
        const chartData = <?php echo $jsonChartData; ?>;
        new Chart(ctx, {
            type: 'doughnut',
            data: {
                labels: chartData.labels,
                datasets: [{
                    label: 'Application Status',
                    data: chartData.data,
                    backgroundColor: chartData.backgroundColor,
                    hoverOffset: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });

        // Gender Chart
        const genderCtx = document.getElementById('genderChart').getContext('2d');
        const genderChartData = <?php echo $jsonGenderChartData; ?>;
        new Chart(genderCtx, {
            type: 'doughnut',
            data: {
                labels: genderChartData.labels,
                datasets: [{
                    label: 'Gender Distribution',
                    data: genderChartData.data,
                    backgroundColor: genderChartData.backgroundColor,
                    hoverOffset: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
        
        // Caste Chart
        const casteCtx = document.getElementById('casteChart').getContext('2d');
        const casteChartData = <?php echo $jsonCasteChartData; ?>;
        new Chart(casteCtx, {
            type: 'doughnut',
            data: {
                labels: casteChartData.labels,
                datasets: [{
                    label: 'Caste Distribution',
                    data: casteChartData.data,
                    backgroundColor: casteChartData.backgroundColor,
                    hoverOffset: 4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
    });

    document.addEventListener('DOMContentLoaded', function () {
        // Initialize DataTables with the lengthMenu option and buttons for export
        const dataTable = $('#datatablesSimple').DataTable({
            "lengthMenu": [10, 25, 50, 100, 200],
            "columnDefs": [
                { "width": "150px", "targets": 4 } // Adjusting the width of the fifth column (index 4)
            ],
            dom: 'Bfrtip',
            buttons: [
                {
                    extend: 'pdfHtml5',
                    text: 'Export PDF',
                    orientation: 'landscape',
                    pageSize: 'A3',
                    title: '',
                    filename: 'TNEDII_PG_DIP_2024-25',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude the last column (View)
                    },
                    customize: function (doc) {
                        // Add custom header to the PDF document
                        doc.content.splice(0, 0, {
                            text: 'TNEDII_PG Diploma Entrepreneurship & Innovation 2024 - 25',
                            margin: [0, 0, 0, 2],
                            alignment: 'center',
                            fontSize: 8
                        });

                        // Customize the PDF document if needed
                        doc.defaultStyle.fontSize = 3;
                        doc.styles.tableHeader.fontSize = 4;
                        doc.styles.tableHeader.alignment = 'center';

                        // Extract data for the table
                        var tableData = [];
                        $('#datatablesSimple tbody tr').each(function () {
                            var district = $(this).find('td:eq(32)').text(); // Communication City (District)
                            var statusApproved = $(this).find('td:eq(38)').text(); // Approved
                            var statusPending = $(this).find('td:eq(38)').text(); // Document_uploaded
                            var statusVerified = $(this).find('td:eq(38)').text(); // Verified
                            tableData.push([district, statusApproved, statusPending, statusVerified]);
                        });
                    }
                },
                {
                    extend: 'csvHtml5',
                    text: 'Export CSV',
                    exportOptions: {
                        columns: ':not(:last-child)' // Exclude the last column (View) only for CSV export
                    }
                },
                {
                    text: 'Export District Data',
                    action: function (e, dt, node, config) {
                        var districtData = {};

                        // Iterate through each row of the table
                        $('#datatablesSimple tbody tr').each(function () {
                            var district = $(this).find('td:eq(35)').text(); // Communication City (District)
                            var status = $(this).find('td:eq(38)').text(); // Status

                            // If the district is not already in the districtData object, initialize counts
                            if (!districtData[district]) {
                                districtData[district] = {
                                    approved: 0,
                                    pending: 0,
                                    verified: 0
                                };
                            }

                            // Increment counts based on the status
                            if (status === 'Approved') {
                                districtData[district].approved++;
                            } else if (status === 'Document_uploaded') {
                                districtData[district].pending++;
                            } else if (status === 'Verified') {
                                districtData[district].verified++;
                            }
                        });

                        // Create CSV content
                        var csv = 'District,Approved Application Count,Pending Application Count,Verified Application Count\n';
                        Object.keys(districtData).forEach(function (district) {
                            var data = districtData[district];
                            csv += district + ',' + data.approved + ',' + data.pending + ',' + data.verified + '\n';
                        });

                        // Download the CSV file
                        var blob = new Blob([csv], { type: 'text/csv;charset=utf-8;' });
                        if (navigator.msSaveBlob) {
                            // IE 10+
                            navigator.msSaveBlob(blob, 'District_Data.csv');
                        } else {
                            // Other browsers
                            var link = document.createElement('a');
                            if (link.download !== undefined) {
                                // Browsers that support HTML5 download attribute
                                var url = URL.createObjectURL(blob);
                                link.setAttribute('href', url);
                                link.setAttribute('download', 'District_Data.csv');
                                document.body.appendChild(link);
                                link.click();
                                document.body.removeChild(link);
                            }
                        }
                    }
                }
            ]
        });
         // Event listener for the district summary button
    document.getElementById('districtSummaryButton').addEventListener('click', function() {
        updateDistrictSummaryModal();
    });

    // Function to update the modal with district summary
    function updateDistrictSummaryModal() {
        var districtData = {};
        $('#datatablesSimple tbody tr').each(function () {
            var district = $(this).find('td:eq(35)').text(); // Communication City (District)
            var status = $(this).find('td:eq(38)').text(); // Status
            if (!districtData[district]) {
                districtData[district] = {
                    approved: 0,
                    pending: 0,
                    verified: 0
                };
            }
            if (status === 'Approved') {
                districtData[district].approved++;
            } else if (status === 'Document_uploaded') {
                districtData[district].pending++;
            } else if (status === 'Verified') {
                districtData[district].verified++;
            }
        });

        var tableBody = $('#districtSummaryTableBody');
        tableBody.empty(); // Clear existing data

        Object.keys(districtData).forEach(function (district) {
            var data = districtData[district];
            var row = `<tr>
                <td>${district}</td>
                <td>${data.approved}</td>
                <td>${data.pending}</td>
                <td>${data.verified}</td>
            </tr>`;
            tableBody.append(row);
        });
    }

        function filterTable() {
            const districtValue = document.getElementById('districtFilter').value.toLowerCase();
            const fieldValue = document.getElementById('fieldFilter').value.toLowerCase();
            const statusValue = document.getElementById('statusFilter').value.toLowerCase();
            const casteValue = document.getElementById('casteFilter').value.toLowerCase();

            $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
                const district = data[35].toLowerCase(); // Communication City (District)
                const field = data[17].toLowerCase(); // Field
                const status = data[38].toLowerCase(); // Status
                const caste = data[8].toLowerCase(); // Caste

                const districtMatch = !districtValue || district.includes(districtValue);
                const fieldMatch = !fieldValue || field.includes(fieldValue);
                const statusMatch = !statusValue || status.includes(statusValue);
                const casteMatch = !casteValue || caste.includes(casteValue);

                return districtMatch && fieldMatch && statusMatch && casteMatch;
            });

            // Check if any filter is applied
            const isAnyFilterApplied = districtValue || fieldValue || statusValue || casteValue;

            // Set the page length to 1000 if any filter is applied, otherwise reset to default (4)
            dataTable.page.len(isAnyFilterApplied ? 1000 : 4).draw();

            $.fn.dataTable.ext.search.pop();
        }

        document.getElementById('districtFilter').addEventListener('change', filterTable);
        document.getElementById('fieldFilter').addEventListener('change', filterTable);
        document.getElementById('statusFilter').addEventListener('change', filterTable);
        document.getElementById('casteFilter').addEventListener('change', filterTable);
        document.getElementById('resetFilters').addEventListener('click', function () {
            document.getElementById('districtFilter').value = '';
            document.getElementById('fieldFilter').value = '';
            document.getElementById('statusFilter').value = '';
            document.getElementById('casteFilter').value = '';
            filterTable();
        });
    });
    </script>
<?php } ?>



    <script>
        $(document).ready(function() {
    // Open remark modal and set app number
    $('.btnremark').click(function() {
        var appNo = $(this).data('appno');
        $('#remarkAppNo').val(appNo);
    });

    // Handle change event of the select input
    $('#remarkSelect').change(function() {
        var selectedOption = $(this).val();
        if (selectedOption === 'other') {
            $('#remarkText').show().prop('required', true);
        } else {
            $('#remarkText').hide().prop('required', false);
        }
    });

    // Handle remark form submission
    $('#remarkForm').submit(function(e) {
        e.preventDefault();
        var appNo = $('#remarkAppNo').val();
        var remark = $('#remarkText').val() || $('#remarkSelect').val(); // Use text input value if available

        $.ajax({
            type: 'POST',
            url: 'config/remark.php', // PHP file to handle the remark update
            data: { app_no: appNo, remark: remark },
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                   $('#remarkSelect').val('default');
                       $('#remarkText').val('').hide(); 
                    $('#remarkModal').modal('hide');
                  
                } else {
                    alert('Error adding remark');
                }
            },
            error: function(xhr, status, error) {
                
                console.error(xhr.responseText);
            }
        });
    });

  
});

    </script>
<script>
    $(document).ready(function() {
        // Handler for view modal button click
        $('.btn-primary').click(function() {
            var appNo = $(this).data('appno');
            // AJAX request to fetch data for the modal
            $.ajax({
                type: 'GET',
                url: 'config/appview.php', // Change to your actual endpoint to fetch application data
                data: {
                    app_no: appNo
                },
                success: function(response) {
                    $('#staticBackdrop .modal-body').html(response);
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        });
    });
</script>

<script>
    
</script>
<script>
    $(document).ready(function() {
        // Handler for view modal button click
        $('.btnverify').click(function() {
            var appNo = $(this).data('appno');
            // AJAX request to fetch data for the modal
            $.ajax({
                type: 'GET',
                url: 'config/docview.php', // Change to your actual endpoint to fetch application data
                data: {
                    app_no: appNo
                },
                success: function(response) {
                    $('#staticBackdrop3 .modal-body').html(response);
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        });
        
    });
</script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Function to send AJAX request
    function updateApplicationStatus(appNo, status) {
        fetch('config/updatestatus.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ app_no: appNo, status: status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
                // Update the status in the table
                document.querySelector(`#status-${appNo}`).textContent = status;
            } else {
                alert('Error updating status');
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }

    // Add event listeners for modal confirm accept buttons
    document.querySelectorAll('.conacc').forEach(button => {
        button.addEventListener('click', function() {
            const appNo = this.closest('.modal').querySelector('.btn-success').getAttribute('data-appno');
            updateApplicationStatus(appNo, 'Approved');
        });
    });
        document.querySelectorAll('.conver').forEach(button => {
        button.addEventListener('click', function() {
            const appNo = this.closest('.modal').querySelector('.btn-success').getAttribute('data-appno');
            updateApplicationStatus(appNo, 'Verified');
        });
    });

    // Add event listeners for modal confirm reject buttons
    document.querySelectorAll('.conrej').forEach(button => {
        button.addEventListener('click', function() {
            const appNo = this.closest('.modal').querySelector('.btn-danger').getAttribute('data-appno');
            updateApplicationStatus(appNo, 'Reject');
        });
    });

    // Add data-appno attribute to modal buttons
    document.querySelectorAll('.btn-success, .btn-danger').forEach(button => {
        button.addEventListener('click', function() {
            const appNo = this.getAttribute('data-appno');
            document.querySelector('.conacc').setAttribute('data-appno', appNo);
            document.querySelector('.conver').setAttribute('data-appno', appNo);
            document.querySelector('.conrej').setAttribute('data-appno', appNo);
        });
    });

      function getSelectedAppNos() {
                var selectedAppNos = [];
                $('input.form-check-input:checked').each(function() {
                    selectedAppNos.push($(this).data('appno'));
                });
                return selectedAppNos;
            }

            function bulkUpdateApplicationStatus(status) {
                var selectedAppNos = getSelectedAppNos();
                selectedAppNos.forEach(function(appNo) {
                    updateApplicationStatus(appNo, status);
                });
                location.reload();
            }

            $('.bulk-verify').click(function() {
                bulkUpdateApplicationStatus('Verified');
            });

            $('.bulk-accept').click(function() {
                bulkUpdateApplicationStatus('Approved');
            });

            $('.bulk-reject').click(function() {
                bulkUpdateApplicationStatus('Reject');
            });
        });
    </script>
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js"></script>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
        <script src="assets/demo/chart-area-demo.js"></script>
        <script src="assets/demo/chart-bar-demo.js"></script>
        <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
        <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.2.3/js/dataTables.buttons.min.js"></script>
        <script src="https://cdn.datatables.net/buttons/2.2.3/js/buttons.html5.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.68/pdfmake.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.68/vfs_fonts.js"></script>
     


    </body>
</html>
