<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>TNEDII - ADMIN</title>
    <link href="css/new.css" rel="stylesheet" />
    <script src="https://use.fontawesome.com/releases/v6.3.0/js/all.js" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" crossorigin="anonymous"></script>
    <link href='https://unpkg.com/boxicons@2.1.2/css/boxicons.min.css' rel='stylesheet'>
    <style>

    </style>
    <script>
        $(document).ready(function() {
            $('#loginForm').on('submit', function(event) {
                event.preventDefault();
                var formData = {
                    email: $('#inputEmail').val(),
                    password: $('#inputPassword').val(),
                    district: $('#selectDistrict').val()
                };
                $.ajax({
                    type: 'POST',
                    url: 'config/log.php',
                    data: formData,
                    dataType: 'json',
                    encode: true
                })
                .done(function(data) {
                    if (data.success) {
                        window.location.href = 'dash.php';
                    } else {
                        $('#message').html('<div class="alert alert-danger">' + data.message + '</div>');
                    }
                })
                .fail(function(data) {
                    $('#message').html('<div class="alert alert-danger">An error occurred. Please try again.</div>');
                });
            });

           
        });
    </script>
    <script src="https://accounts.google.com/gsi/client" async defer></script>
<script>
    function handleCredentialResponse(response) {
        $.ajax({
            type: 'POST',
            url: 'config/gapi/glogin.php',
            data: { id_token: response.credential },
            dataType: 'json',
            encode: true
        })
        .done(function(data) {
            if (data.success) {
                window.location.href = 'dash.php';
            } else {
                $('#message').html('<div class="alert alert-danger">' + data.message + '</div>');
            }
        })
        .fail(function(data) {
            $('#message').html('<div class="alert alert-danger">An error occurred. Please try again.</div>');
        });
    }

    window.onload = function () {
        google.accounts.id.initialize({
            client_id: '318439917710-bn7e256nkur9suh330035tfbovvk2acg.apps.googleusercontent.com', // Replace with your Google Client ID
            callback: handleCredentialResponse
        });
        google.accounts.id.renderButton(
            document.getElementById('googleSignInButton'),
            { theme: 'outline', size: 'large' } // Customization attributes
        );
        google.accounts.id.prompt(); // Display the One Tap prompt
    };
</script>
<style>
    #togglePassword{
        margin-top: 7px;
    }
</style>

</head>
<body>
       
    <section class="container forms">
        <div class="form login">
            <div class="form-content">
            
                <header>TNEDII - LOGIN</header>
                  <div id="message"></div>
                <form id="loginForm">
                    <div class="field input-field">
                        <input class="form-control" id="inputEmail" name="email" type="email" placeholder="name@example.com" required />
                    </div>
                    <div class="field input-field">
                        <input class="form-control" id="inputPassword" name="password" type="password" placeholder="Password" required />
                           <i class='bx bx-hide eye-icon mt-2' id="togglePassword"></i>
                    </div>
                    <div class="field input-field" id="districtselect">
                        <select class="form-control input-field field" id="selectDistrict" name="district" required>
                            <option value="">Select District</option>
                          <option value="Ariyalur">Ariyalur</option>
                            <option value="Chengalpattu">Chengalpattu</option>
                            <option value="Chennai">Chennai</option>
                            <option value="Coimbatore">Coimbatore</option>
                            <option value="Cuddalore">Cuddalore</option>
                            <option value="Dharmapuri">Dharmapuri</option>
                            <option value="Dindigul">Dindigul</option>
                            <option value="Erode">Erode</option>
                            <option value="Kallakurichi">Kallakurichi</option>
                            <option value="Kanchipuram">Kanchipuram</option>
                            <option value="Karur">Karur</option>
                            <option value="Krishnagiri">Krishnagiri</option>
                            <option value="Kanyakumari">Kanyakumari</option>
                            <option value="Madurai">Madurai</option>
                            <option value="Nagapattinam">Nagapattinam</option>
                            <option value="Namakkal">Namakkal</option>
                            <option value="Nilgiris">Nilgiris</option>
                            <option value="Perambalur">Perambalur</option>
                            <option value="Pudukkottai">Pudukkottai</option>
                            <option value="Ramanathapuram">Ramanathapuram</option>
                            <option value="Ranipet">Ranipet</option>
                            <option value="Salem">Salem</option>
                            <option value="Sivaganga">Sivaganga</option>
                            <option value="Tenkasi">Tenkasi</option>
                            <option value="Thanjavur">Thanjavur</option>
                            <option value="Theni">Theni</option>
                            <option value="Thiruvallur">Thiruvallur</option>
                            <option value="Thiruvarur">Thiruvarur</option>
                            <option value="Thoothukudi">Thoothukudi</option>
                            <option value="Tiruchirappalli">Tiruchirappalli</option>
                            <option value="Tirunelveli">Tirunelveli</option>
                            <option value="Tirupattur">Tirupattur</option>
                            <option value="Tiruppur">Tiruppur</option>
                            <option value="Tiruvannamalai">Tiruvannamalai</option>
                            <option value="Vellore">Vellore</option>
                            <option value="Viluppuram">Viluppuram</option>
                            <option value="Virudhunagar">Virudhunagar</option>
                        </select>
                    </div>
                    <div></div>
                 
                 
                    <div class="field button-field ">
                        <button class="btn btn-primary" type="submit">Login</button>
                    </div>
                </form>
              
            </div>
            <div class="line"></div>
            <div class="media-options">
                <div id="googleSignInButton"></div> <!-- Google Sign-In button -->
            </div>
        </div>
    </section>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" crossorigin="anonymous"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
    const togglePassword = document.getElementById('togglePassword');
    const passwordField = document.getElementById('inputPassword');

    togglePassword.addEventListener('click', function() {
        // Toggle the type attribute using getAttribute() and setAttribute()
        const type = passwordField.getAttribute('type') === 'password' ? 'text' : 'password';
        passwordField.setAttribute('type', type);

        // Toggle the eye icon class
        this.classList.toggle('bx-hide');
        this.classList.toggle('bx-show');
    });
});
</script>
    <script src="js/new.js"></script>
</body>
</html>
