
<?php

session_start();

$user_email = $_SESSION['user_email'];


require 'config/db2.php'; // Ensure this path is correct


$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Query to get counts for each status
$sql_total = "SELECT COUNT(*) AS total FROM application_form";
$sql_pending = "SELECT COUNT(*) AS pending FROM application_form WHERE statusapp = 'Document_uploaded'";
$sql_verified = "SELECT COUNT(*) AS verified FROM application_form WHERE statusapp = 'Verified'";
$sql_declined = "SELECT COUNT(*) AS declined FROM application_form WHERE statusapp = 'Reject'";
$sql_approved = "SELECT COUNT(*) AS approved FROM application_form WHERE statusapp = 'Approved'";

$result_total = $conn->query($sql_total);
$result_pending = $conn->query($sql_pending);
$result_verified = $conn->query($sql_verified);
$result_declined = $conn->query($sql_declined);
$result_approved = $conn->query($sql_approved);


$pending = $result_pending->fetch_assoc();
$verified = $result_verified->fetch_assoc();
$declined = $result_declined->fetch_assoc();
$approved = $result_approved->fetch_assoc();

$total = $pending['pending'] + $verified['verified'] + $declined['declined'] + $approved['approved'];


$sql = "SELECT * FROM application_form WHERE statusapp IN ('Document_uploaded', 'Approved', 'Reject', 'Verified','started') ORDER BY app_no DESC";
$result = $conn->query($sql);
$chartData = [
    'labels' => ['Pending','Declined', 'Approved'],
    'data' => [
        $pending['pending'],
        $declined['declined'],
        $approved['approved']
    ],
    'backgroundColor' => [
        'rgb(255, 99, 132)',
        'rgb(255, 205, 86)',
        'rgb(75, 192, 192)'
    ]
];

$jsonChartData = json_encode($chartData);

// Close the connection
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>TNEDII - ADMIN</title>
        <link href="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/style.min.css" rel="stylesheet" />
        <link href="css/styles.css" rel="stylesheet" />
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400..700;1,400..700&family=Nunito:ital,wght@0,200..1000;1,200..1000&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
        <script src="https://use.fontawesome.com/releases/v6.3.0/js/all.js" crossorigin="anonymous"></script>
    
        <script>    // Prevent back navigation after logout
            if (window.history && window.history.pushState) {
                window.history.pushState(null, null, window.location.href);
                window.onpopstate = function () {
                    window.history.pushState(null, null, window.location.href);
                };
            }</script>

<style>
.navbar-dark .navbar-brand {
    background: whitesmoke;
    color: #000;
}
.navbar-dark .navbar-brand:hover {
    background: whitesmoke;
    color: #000;
}

.navbar-dark .navbar-nav .nav-link{
    color: gray;
}
.navbar-dark .navbar-nav .nav-link:hover{
    color: gray;
}
.navbar-dark .navbar-nav .nav-link:focus{
    color:gray;
}
        .container {
            border-radius: 8px;
            background: white;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .container .form-group label {
            font-weight: bold;
        }
        
        .container .form-group {
            margin-bottom: 30px;
        }


        .container .form-group p {
            margin-bottom: 0;
        }

        .container .img-fluid {
            max-width: 100px;
            height: auto;
            border-radius: 8px;
            margin-top: 10px;
        }

        .embed-responsive {
            position: relative;
            display: block;
            width: 100%;
            padding: 0;
            overflow: hidden;
        }

        .embed-responsive::before {
            display: block;
            content: "";
        }

        .embed-responsive-16by9::before {
            padding-top: 56.25%;
        }

        .embed-responsive-item {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 0;
        }
        .stacard{
            height: 380px;
        }
        .card{
            border: none;
        }
        .sb-topnav {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

     
    </style>
    </head>
    <body class="sb-nav-fixed">
        <nav class="sb-topnav navbar navbar-expand navbar-dark">
             <a class="logotxt" href="index.html">EDII-TN</a>
            <!-- Sidebar Toggle-->
              <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!"><i class="fas fa-bars"></i></button>
      
            <div class="logotn"> <img src="images/adminlogo1.png" alt="" srcset=""></div>
            <div class="logotn1"> <img src="images/logo1.png" alt="" srcset=""></div>
             <!-- Navbar-->
            <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-user fa-fw"></i></a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <li><a class="dropdown-item" href="#!">Settings</a></li>
                        <li><a class="dropdown-item" href="#!">Activity Log</a></li>
                     <li><a class="dropdown-item" href="#">Reset Password</a></li>
                        <li><hr class="dropdown-divider" /></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
           
        </nav>
       
        <div id="layoutSidenav">
            
           <div id="layoutSidenav_nav">
                <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                    <div class="sb-sidenav-menu">
                        <div class="nav">
                            <div class="sb-sidenav-menu-heading">Core</div>
                            <a class="nav-link" href="dash.php">
                                <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                                Dashboard
                            </a>
                            <div class="sb-sidenav-menu-heading">Application</div>
                           
                            <div class="collapse" id="collapsePages" aria-labelledby="headingTwo" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav accordion" id="sidenavAccordionPages">
                                    <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#pagesCollapseAuth" aria-expanded="false" aria-controls="pagesCollapseAuth">
                                        Authentication
                                        <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                                    </a>
                                   
                                    <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#pagesCollapseError" aria-expanded="false" aria-controls="pagesCollapseError">
                                        Error
                                        <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                                    </a>
                                    <div class="collapse" id="pagesCollapseError" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordionPages">
                                        <nav class="sb-sidenav-menu-nested nav">
                                            <a class="nav-link" href="401.html">401 Page</a>
                                            <a class="nav-link" href="404.html">404 Page</a>
                                            <a class="nav-link" href="500.html">500 Page</a>
                                        </nav>
                                    </div>
                                </nav>
                            </div>
                           
                        </div>
                    </div>
                    <div class="sb-sidenav-footer">
                        <div class="small">Logged in as:</div>
                        EDII-TN <?php echo $user_role ?>
                    </div>
                </nav>
            </div>
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                    <div class="row justify-content-center">
                        <div class="col-lg-5">
                            <div class="card shadow-lg border-0 rounded-lg mt-5">
                                <div class="card-header"><h3 class="text-center font-weight-light my-4">Reset Password</h3></div>
                                <div class="card-body">
                                    <form id="forgetForm">
                                        <div class="form-floating mb-3">
                                            <input class="form-control" id="inputEmail" name="email" type="email" value="<?php echo $user_email; ?>" placeholder="name@example.com"  hidden required />
                                           
                                        </div>
                                        <div class="form-floating mb-3">
                                            <input class="form-control" id="inputNewPassword" name="new_password" type="password" placeholder="New Password" required />
                                            <label for="inputNewPassword">New Password</label>
                                        </div>
                                        <div class="form-floating mb-3">
                                            <input class="form-control" id="inputConfirmPassword" name="confirm_password" type="text" placeholder="Confirm New Password" required />
                                            <label for="inputConfirmPassword">Confirm New Password</label>
                                        </div>
                                        <div class="d-flex align-items-center justify-content-between mt-4 mb-0">
                                            <button class="btn btn-primary" type="submit">Reset Password</button>
                                        </div>
                                    </form>
                                    <div id="message"></div>
                                </div>
                              
                            </div>
                        </div>
                </div>
                       
                    </div>
                </main>
                <footer class="py-4 bg-light mt-auto">
                    <div class="container-fluid px-4">
                        <div class="d-flex align-items-center justify-content-between small">
                            <div class="text-muted">Copyright &copy; TNEDII @ 2024</div>
                            <div>
                                <a href="#">Privacy Policy</a>
                                &middot;
                                <a href="#">Terms &amp; Conditions</a>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
  
 <script>
        $(document).ready(function() {
            $('#forgetForm').on('submit', function(event) {
                event.preventDefault();
                var formData = $(this).serialize();
                $.ajax({
                    type: 'POST',
                    url: 'reset.php',
                    data: formData,
                    dataType: 'json',
                    encode: true
                })
                .done(function(data) {
                    $('#message').html('<div class="alert alert-' + (data.success ? 'success' : 'danger') + '">' + data.message + '</div>');
                })
                .fail(function(data) {
                    $('#message').html('<div class="alert alert-danger">An error occurred. Please try again.</div>');
                });
            });
        });
    </script>


        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
        <script src="assets/demo/chart-area-demo.js"></script>
        <script src="assets/demo/chart-bar-demo.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js" crossorigin="anonymous"></script>
        <script src="js/datatables-simple-demo.js"></script>
    </body>
</html>

