<?php
session_start();

require 'config/db2.php'; // Ensure this path is correct

// Establish database connection
$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$user_role = $_SESSION['user_role'];
$district = $_SESSION['district'];


// Initialize variables for query results
$pending = $verified = $declined = $approved = [];
$total = 0;


// Append district filter for users (non-admin roles)
if ($user_role == 'User') {
    $sql_total = "SELECT COUNT(*) AS total FROM application_form WHERE communication_city = '$district'";
    $sql_pending = "SELECT COUNT(*) AS pending FROM application_form WHERE statusapp = 'Document_uploaded' AND communication_city = '$district'";
    $sql_verified = "SELECT COUNT(*) AS verified FROM application_form WHERE statusapp = 'Verified' AND communication_city = '$district'";
    $sql_declined = "SELECT COUNT(*) AS declined FROM application_form WHERE statusapp = 'Reject' AND communication_city = '$district'";
    $sql_approved = "SELECT COUNT(*) AS approved FROM application_form WHERE statusapp = 'Approved' AND communication_city = '$district'";
}
else {
    
    // Base SQL queries
$sql_total = "SELECT COUNT(*) AS total FROM application_form";
$sql_pending = "SELECT COUNT(*) AS pending FROM application_form WHERE statusapp = 'Document_uploaded'";
$sql_verified = "SELECT COUNT(*) AS verified FROM application_form WHERE statusapp = 'Verified'";
$sql_declined = "SELECT COUNT(*) AS declined FROM application_form WHERE statusapp = 'Reject'";
$sql_approved = "SELECT COUNT(*) AS approved FROM application_form WHERE statusapp = 'Approved'";
}

$result_total = $conn->query($sql_total);
$result_pending = $conn->query($sql_pending);
$result_verified = $conn->query($sql_verified);
$result_declined = $conn->query($sql_declined);
$result_approved = $conn->query($sql_approved);

$pending = $result_pending->fetch_assoc();
$verified = $result_verified->fetch_assoc();
$declined = $result_declined->fetch_assoc();
$approved = $result_approved->fetch_assoc();
$total = $pending['pending'] + $verified['verified'] + $declined['declined'] + $approved['approved'];

// Adjust SQL query for application list based on role
if ($user_role == "User") {
    $sql = "SELECT * FROM application_form WHERE communication_city = '$district' AND statusapp IN ('Document_uploaded', 'Approved', 'Reject', 'Verified', 'started') ORDER BY app_no DESC  LIMIT 5";
} else {
    $sql = "SELECT * FROM application_form WHERE statusapp IN ('Document_uploaded', 'Approved', 'Reject', 'Verified', 'started') ORDER BY app_no DESC  LIMIT 5";
}


// Execute SQL query for application list
$result = $conn->query($sql);

// Prepare chart data
$chartData = [
    'labels' => ['Pending', 'Declined', 'Approved'],
    'data' => [
        $pending['pending'],
        $declined['declined'],
        $approved['approved']
    ],
    'backgroundColor' => [
        'rgb(255, 99, 132)',
        'rgb(255, 205, 86)',
        'rgb(75, 192, 192)'
    ]
];

$jsonChartData = json_encode($chartData);

// Close the connection
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
        <meta name="description" content="" />
        <meta name="author" content="" />
        <title>EDII-TN - ADMIN</title>
        <link href="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/style.min.css" rel="stylesheet" />
        <link href="css/styles.css" rel="stylesheet" />
                <link href="css/view.css" rel="stylesheet" />

        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Lora:ital,wght@0,400..700;1,400..700&family=Nunito:ital,wght@0,200..1000;1,200..1000&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
<link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

  <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.3/dist/chart.umd.min.js"></script>
        <script src="https://use.fontawesome.com/releases/v6.3.0/js/all.js" crossorigin="anonymous"></script>
    
        <script>    // Prevent back navigation after logout
            if (window.history && window.history.pushState) {
                window.history.pushState(null, null, window.location.href);
                window.onpopstate = function () {
                    window.history.pushState(null, null, window.location.href);
                };
            }</script>

<style>
.navbar-dark .navbar-brand {
    background: whitesmoke;
    color: #000;
}
.navbar-dark .navbar-brand:hover {
    background: whitesmoke;
    color: #000;
}

.navbar-dark .navbar-nav .nav-link{
    color: gray;
}
.navbar-dark .navbar-nav .nav-link:hover{
    color: gray;
}
.navbar-dark .navbar-nav .nav-link:focus{
    color:gray;
}
        .container {
            border-radius: 8px;
            background: white;
            padding: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        .container .form-group label {
            font-weight: bold;
        }
        
        .container .form-group {
            margin-bottom: 30px;
        }


        .container .form-group p {
            margin-bottom: 0;
        }

        .container .img-fluid {
            max-width: 100px;
            height: auto;
            border-radius: 8px;
            margin-top: 10px;
        }

        .embed-responsive {
            position: relative;
            display: block;
            width: 100%;
            padding: 0;
            overflow: hidden;
        }

        .embed-responsive::before {
            display: block;
            content: "";
        }

        .embed-responsive-16by9::before {
            padding-top: 56.25%;
        }

        .embed-responsive-item {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 0;
        }
        .stacard{
            height: 380px;
        }
        .card{
            border: none;
        }
        .sb-topnav {
    display: flex;
    align-items: center;
    justify-content: space-between;
}

     
    </style>
    </head>
    <body class="sb-nav-fixed">
        <nav class="sb-topnav navbar navbar-expand navbar-dark">
                   <a class="logotxt" href="index.php">EDII-TN</a>
            <!-- Sidebar Toggle-->
              <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle" href="#!"><i class="fas fa-bars"></i></button>
      
            <div class="logotn"> <img src="images/adminlogo1.png" alt="" srcset=""></div>
            <div class="logotn1"> <img src="images/logo1.png" alt="" srcset=""></div>
             <!-- Navbar-->
            <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4">
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-user fa-fw"></i></a>
                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                        <li><a class="dropdown-item" href="#!">Settings</a></li>
                        <li><a class="dropdown-item" href="#!">Activity Log</a></li>
                           <li><a class="dropdown-item" href="forget.php">Reset Password</a></li>
                        <li><hr class="dropdown-divider" /></li>
                        <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                    </ul>
                </li>
            </ul>
           
        </nav>
       
        <div id="layoutSidenav">
            
           <div id="layoutSidenav_nav">
                <nav class="sb-sidenav accordion sb-sidenav-dark" id="sidenavAccordion">
                    <div class="sb-sidenav-menu">
                        <div class="nav">
                            <div class="sb-sidenav-menu-heading"><?php echo ($user_role == 'User') ? " - $district ADMIN"  : ''; ?></div>
                            <a class="nav-link" href="#">
                                <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                                Dashboard
                            </a>
                            <div class="sb-sidenav-menu-heading">Application</div>
                            <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#collapseLayouts" aria-expanded="false" aria-controls="collapseLayouts">
                                <div class="sb-nav-link-icon"><i class="fas fa-columns"></i></div>
                                Actions
                                <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                            </a>
                            <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                       <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="action.php">Take Action</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                            <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                     <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                       <a class="nav-link" href="entry.php">Entry List</a>
                                        <?php endif; ?>
                                </nav>
                            </div>
                           
                             <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                      <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="verified.php">Pending Application</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                        
                             <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                      <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="reject.php">Rejected Application</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                            <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                      <?php if ($user_role == 'Admin' || $user_role == 'SuperAdmin'): ?>
                                    <a class="nav-link" href="approve.php">Approved Application</a>
                                     <?php endif; ?>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                             <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav">
                                    <a class="nav-link" href="report.php">Report</a>
                                    <!-- <a class="nav-link" href="layout-sidenav-light.html">Light Sidenav</a> -->
                                </nav>
                            </div>
                              
                            <div class="collapse" id="collapseLayouts" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordion">
                                            <nav class="sb-sidenav-menu-nested nav">
                                                  <?php if ($user_role == "SuperAdmin") { ?>
                                                <a class="nav-link" href="invite.php">Invite Reapplicants</a>
                                                 <?php } ?>
                                                <!-- Add other menu items here if needed -->
                                            </nav>
                            </div>
                                   
                            <div class="collapse" id="collapsePages" aria-labelledby="headingTwo" data-bs-parent="#sidenavAccordion">
                                <nav class="sb-sidenav-menu-nested nav accordion" id="sidenavAccordionPages">
                                    <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#pagesCollapseAuth" aria-expanded="false" aria-controls="pagesCollapseAuth">
                                        Authentication
                                        <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                                    </a>
                                    <div class="collapse" id="pagesCollapseAuth" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordionPages">
                                        <nav class="sb-sidenav-menu-nested nav">
                                            <a class="nav-link" href="login.html">Login</a>
                                            <a class="nav-link" href="register.html">Register</a>
                                            <a class="nav-link" href="password.html">Forgot Password</a>
                                        </nav>
                                    </div>
                                    <a class="nav-link collapsed" href="#" data-bs-toggle="collapse" data-bs-target="#pagesCollapseError" aria-expanded="false" aria-controls="pagesCollapseError">
                                        Error
                                        <div class="sb-sidenav-collapse-arrow"><i class="fas fa-angle-down"></i></div>
                                    </a>
                                    <div class="collapse" id="pagesCollapseError" aria-labelledby="headingOne" data-bs-parent="#sidenavAccordionPages">
                                        <nav class="sb-sidenav-menu-nested nav">
                                            <a class="nav-link" href="401.html">401 Page</a>
                                            <a class="nav-link" href="404.html">404 Page</a>
                                            <a class="nav-link" href="500.html">500 Page</a>
                                        </nav>
                                    </div>
                                </nav>
                            </div>
                           
                        </div>
                    </div>
                    <div class="sb-sidenav-footer">
                        <div class="small">Logged in as:  <?php echo $user_role ?> </div>
                        EDII-TN
                    </div>
                </nav>
            </div>
            <div id="layoutSidenav_content">
                <main>
                    <div class="container-fluid px-4">
                        <h3 class="mt-4">Dashboard</h3>
                        <ol class="breadcrumb mb-4">
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                        <div class="row">
                            
        
                            <ul class="box-info">
                				<li>
                					<i class='bx bxs-plus-square'></i>
                					<span class="text">
                						<h3><?php echo $total ?></h3>
                						<p>Total Application</p>
                					</span>
                				</li>
                				<li>
                			<i class='bx bx-pause-circle'></i>
                					<span class="text">
                						<h3><?php echo $pending['pending']; ?></h3>
                						<p>Pending</p>
                					</span>
                				</li>
                				<li>
                				<i class='bx bxs-check-square'></i>
                					<span class="text">
                						<h3><?php echo $verified['verified']; ?></h3>
                						<p>Verified</p>
                					</span>
                				</li>
                					<li>
                			<i class='bx bx-user-x' ></i>
                					<span class="text">
                						<h3><?php echo $declined['declined']; ?></h3>
                						<p>Rejected</p>
                					</span>
                				</li>
                					<li>
                				<i class='bx bx-paper-plane'></i>
                					<span class="text">
                						<h3><?php echo $approved['approved']; ?></h3>
                						<p>Approved</p>
                					</span>
                				</li>
                			
                			</ul>                                                           
	
                            
                            
                           
                        </div>
                        <div class="row">
                            <div class="col-xl-8">
                                
                                
                                 <div class="card mb-4">
                            <div class="card-header">
                                <i class="fas fa-table me-1"></i>
                                Recent Application Forms 
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table id="datatablesSimple" width="100%" cellspacing="0">
                                        <thead>
                                            <tr>
                                                <th>Application Number</th>
                                                <th>Name</th>
                                                <th>Mobile</th>
                                                <th>Communication State</th>
                                                <th>Status</th>
                                               
                                            </tr>
                                        </thead>
                                      
                                        <tbody>
                                            <?php
                                            if ($result->num_rows > 0) {
                                                while ($row = $result->fetch_assoc()) {
                                                    echo "<tr>";
                                                    echo "<td>" . $row["app_no"] . "</td>";
                                                    echo "<td>" . $row["first_name"] . " " . $row["last_name"] . "</td>";
                                                    echo "<td>" . $row["mobile"] . "</td>";
                                                    echo "<td>" . $row["communication_state"] . "</td>";
                                                    echo "<td>" . $row["statusapp"] . "</td>";
                                                    // Add a button to trigger the modal
                                                    echo "</tr>";
                                                }
                                            } else {
                                                echo "<tr><td colspan='6'>No data available</td></tr>";
                                            }
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
    
                            <!-- Modal -->


                                    <!-- Modal -->
                                    <div class="modal fade" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-xl">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                            <h1 class="modal-title fs-5" id="staticBackdropLabel">Application Form</h1>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        </div>
                                        </div>
                                    </div>
                                    </div>






                        </div>
                            </div>
                         
                            <div class="col-xl-4">
                                   <div class="card-header">
                                        <i class="fas fa-chart-area me-1"></i>
                                         Application Flow
                                    </div>
                                <div class="card text-white mb-4">
                                      
                                     <div class="card-body stacard">
                                        <canvas id="statusChart" width="350" height="350"></canvas>
                                    </div>

                                </div>
                            </div>
                                
                               
                            
                            </div>
                       
                    </div>
                </main>
                <footer class="py-4 bg-light mt-auto">
                    <div class="container-fluid px-4">
                        <div class="d-flex align-items-center justify-content-between small">
                            <div class="text-muted">Copyright &copy; EDII-TN @ 2024</div>
                            <div>
                                <a href="#">Privacy Policy</a>
                                &middot;
                                <a href="#">Terms &amp; Conditions</a>
                            </div>
                        </div>
                    </div>
                </footer>
            </div>
        </div>
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
        <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Get chart data from PHP
            var chartData = <?php echo $jsonChartData; ?>;
            
            // Set up chart configuration
            var config = {
                 type: 'doughnut',
                data: {
                    labels: chartData.labels,
                    datasets: [{
                        label: 'Application Status',
                        data: chartData.data,
                        backgroundColor: chartData.backgroundColor,
                        hoverOffset: 4
                    }]
                },
                options: {
                    plugins: {
                        legend: {
                            position: 'right'  // Position the legend on the right
                        }
                    }
                }
            };
            
            // Render the chart
            var ctx = document.getElementById('statusChart').getContext('2d');
           var statusChart = new Chart(ctx, config);
        });
    </script>
<script>
    $(document).ready(function() {
        // Handler for view modal button click
        $('.btn-primary').click(function() {
            var appNo = $(this).data('appno');
            // AJAX request to fetch data for the modal
            $.ajax({
                type: 'GET',
                url: 'config/appview.php', // Change to your actual endpoint to fetch application data
                data: {
                    app_no: appNo
                },
                success: function(response) {
                    $('#staticBackdrop .modal-body').html(response);
                },
                error: function(xhr, status, error) {
                    console.error(xhr.responseText);
                }
            });
        });
    });


</script>


        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
        <script src="js/scripts.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.8.0/Chart.min.js" crossorigin="anonymous"></script>
        <script src="assets/demo/chart-area-demo.js"></script>
        <script src="assets/demo/chart-bar-demo.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/simple-datatables@7.1.2/dist/umd/simple-datatables.min.js" crossorigin="anonymous"></script>
        <script src="js/datatables-simple-demo.js"></script>
    </body>
</html>
