<?php
include 'db2.php'; // Include your database connection file

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $appNo = $_POST['app_no'];
    $remark = $_POST['remark'];

    // Prepare and bind
    $sql = "UPDATE application_form SET remark = ? WHERE app_no = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt === false) {
        // Handle errors with preparing the statement
        echo json_encode(array('success' => false, 'message' => 'Error preparing the statement: ' . htmlspecialchars($conn->error)));
        exit;
    }
    $stmt->bind_param('ss', $remark, $appNo);

    // Execute the query
    if ($stmt->execute()) {
        // Success response
        echo json_encode(array('success' => true));
    } else {
        // Error response
        echo json_encode(array('success' => false, 'message' => 'Error updating remark: ' . htmlspecialchars($stmt->error)));
    }

    // Close statement and connection
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(array('success' => false, 'message' => 'Invalid request'));
}
?>
