<?php
header('Content-Type: application/json');
require 'db.php'; // Ensure this path is correct

$response = ['success' => false, 'message' => 'Failed to create account'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $firstName = $_POST['first_name'];
    $roleuser = $_POST['role'];
    $email = $_POST['email'];
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirm_password'];

    if ($password !== $confirmPassword) {
        $response['message'] = 'Passwords do not match';
        echo json_encode($response);
        exit;
    }

    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    // Insert user into the database
    $stmt = $pdo->prepare("INSERT INTO admintndii (first_name, roleuser, email, password) VALUES (:first_name, :roleuser, :email, :password)");
    $result = $stmt->execute([
        'first_name' => $firstName,
        'roleuser' => $roleuser,
        'email' => $email,
        'password' => $hashedPassword,
    ]);

    if ($result) {
        $response = ['success' => true, 'message' => 'Account created successfully'];
    }
}

echo json_encode($response);
?>
