<?php
session_start();
header('Content-Type: application/json');

require 'db.php'; // Ensure this path is correct

$response = ['success' => false, 'message' => 'Invalid username, password, or district'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $password = $_POST['password'];
    $district = $_POST['district'];

    // Fetch user from the database
    $stmt = $pdo->prepare("SELECT * FROM admintndii WHERE email = :email AND district = :district");
    $stmt->execute(['email' => $email, 'district' => $district]);
    $user = $stmt->fetch();
    

    // Verify the password (hashed comparison)
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_email'] = $user['email'];
        $_SESSION['district'] = $user['district'];
        $_SESSION['user_role'] = $user['roleuser'];
        $response = ['success' => true];
    }
}

echo json_encode($response);
?>
