<?php
require 'db2.php'; // Ensure this path is correct

header('Content-Type: application/json');

$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$data = json_decode(file_get_contents('php://input'), true);

$app_no = $data['app_no'];
$status = $data['status'];
$remarks = $data['remarks'];


// Prepare SQL to update status and remarks
$sqlUpdate = "UPDATE application_form SET statusapp = ?, remark = ? WHERE app_no = ?";
$stmtUpdate = $conn->prepare($sqlUpdate);
$stmtUpdate->bind_param('sss', $status, $remarks, $app_no);

// Prepare SQL to delete specific fields
$sqlDelete = "UPDATE application_form SET 
    last_name = NULL,
    date_of_birth = NULL,
    gender = NULL,
    caste = NULL,
    religion = NULL,
    nationality = NULL,
    field = NULL,
    differently_abled = NULL,
    marital_status = NULL,
    fathers_name = NULL,
    father_occupation = NULL,
    fathers_annual_income = NULL,
    fathers_mobile = NULL,
    mothers_name = NULL,
    mother_occupation = NULL,
    mothers_annual_income = NULL,
    mothers_mobile_number = NULL,
    permanent_street_address1 = NULL,
    permanent_street_address2 = NULL,
    permanent_city = NULL,
    permanent_state = NULL,
    permanent_postal_code = NULL,
    communication_street_address1 = NULL,
    communication_street_address2 = NULL,
    communication_postal_code = NULL,
    passport_photo_path = NULL,
    address_proof_path = NULL,
    degree_certificate_path = NULL,
    qualification = NULL,
    university = NULL,
    degree_name = NULL,
    graduation_year = NULL,
    percentage = NULL
    WHERE app_no = ?";
$stmtDelete = $conn->prepare($sqlDelete);
$stmtDelete->bind_param('s', $app_no);

$response = [];

if ($stmtUpdate->execute() && $stmtDelete->execute()) {
    $response['success'] = true;
} else {
    $response['success'] = false;
}

echo json_encode($response);

$stmtUpdate->close();
$stmtDelete->close();
$conn->close();
?>
