<?php
require 'vendor/autoload.php'; // Ensure this path is correct and you have installed the Google API Client Library
require 'gdb.php'; // Ensure the database connection is included
use Google\Client;

session_start();
header('Content-Type: application/json');

$response = ['success' => false, 'message' => 'Invalid token or user does not exist'];

// Replace with your Google Client ID
$client_id = '318439917710-bn7e256nkur9suh330035tfbovvk2acg.apps.googleusercontent.com';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['id_token'])) {
    $client = new Google_Client(['client_id' => $client_id]);  
    $id_token = $_POST['id_token'];

    try {
        $payload = $client->verifyIdToken($id_token);

        if ($payload) {
            $userid = $payload['sub'];
            $email = $payload['email'];

            // Fetch user from the database
            $stmt = $pdo->prepare("SELECT * FROM admintndii WHERE email = :email");
            $stmt->execute(['email' => $email]);
            $user = $stmt->fetch();

            if ($user) {
                // User exists, log them in
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_role'] = $user['roleuser'];
                $response = ['success' => true];
            } else {
                // User does not exist, return failure response
                $response = ['success' => false, 'message' => 'User does not exist'];
            }
        }
    } catch (Exception $e) {
        $response = ['success' => false, 'message' => 'Token verification failed'];
    }
}

echo json_encode($response);
?>
