<?php

require 'db2.php'; // Ensure this path is correct

if (isset($_GET['app_no'])) {
    $appNo = $_GET['app_no'];

    // Using a prepared statement to prevent SQL injection
    $stmt = $conn->prepare("SELECT * FROM application_form WHERE app_no = ?");
    $stmt->bind_param("s", $appNo);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();

        // Define the file path prefix
        $filePathPrefix = '../management/form/admissions/formenter/';

        // Function to generate HTML for files
        function generateFileHtml($filePath, $filePathPrefix) {
            $fullPath = $filePathPrefix . $filePath;
            $fileExtension = pathinfo($fullPath, PATHINFO_EXTENSION);
            $html = '';

            switch (strtolower($fileExtension)) {
                case 'jpg':
                case 'jpeg':
                case 'png':
                case 'gif':
                    $html = '<img src="' . htmlspecialchars($fullPath) . '" class="img-fluid" alt="Uploaded Image">';
                    break;
                case 'pdf':
                    $html = '<embed src="' . htmlspecialchars($fullPath) . '" type="application/pdf" width="80%" height="300px" />';
                    break;
                default:
                    $html = '<a href="' . htmlspecialchars($fullPath) . '" target="_blank">View File</a>';
                    break;
            }

            return $html;
        }

        // HTML for the modal
        $html = '
            <div class="container my-4">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <label><strong>Application Number:  ' . htmlspecialchars($row['app_no']) . '</strong></label>
                        
                    </div>
                </div>
                <table class="table table-bordered  text-center">
                    <tbody>
                        <tr>
                            <td><strong>Passport Photo:</strong></td>
                            <td>' . generateFileHtml($row['passport_photo_path'], $filePathPrefix) . '</td>
                        </tr>
                        <tr>
                            <td><strong>Address Proof:</strong></td>
                            <td>' . generateFileHtml($row['address_proof_path'], $filePathPrefix) . '</td>
                        </tr>
                        <tr>
                            <td><strong>Degree Certificate:</strong></td>
                            <td>' . generateFileHtml($row['degree_certificate_path'], $filePathPrefix) . '</td>
                        </tr>
                    </tbody>
                </table>
            </div>';

        echo $html;
    } else {
        echo 'No application found with the provided application number.';
    }

    $stmt->close();
} else {
    echo 'Application number is not provided.';
}

$conn->close();
?>
