<?php
// config/delete_applications.php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Include your database connection file
    include 'db2.php';

    // Get the application numbers from the POST request
    $appNos = $_POST['app_nos'];

    if (!empty($appNos)) {
        // Prepare the SQL statement with placeholders
        $placeholders = implode(',', array_fill(0, count($appNos), '?'));
        $sql = "DELETE FROM application_form WHERE app_no IN ($placeholders)";

        // Prepare and execute the statement
        if ($stmt = $conn->prepare($sql)) {
            // Bind the application numbers to the placeholders
            $stmt->bind_param(str_repeat('s', count($appNos)), ...$appNos);

            // Execute the statement
            if ($stmt->execute()) {
                echo 'Applications deleted successfully.';
            } else {
                echo 'Error: ' . $stmt->error;
            }

            // Close the statement
            $stmt->close();
        } else {
            echo 'Error: ' . $conn->error;
        }
    } else {
        echo 'No application numbers provided.';
    }

    // Close the database connection
    $conn->close();
} else {
    echo 'Invalid request method.';
}
?>
