<?php

require 'db2.php'; // Ensure this path is correct

if (isset($_GET['app_no'])) {
    $appNo = $_GET['app_no'];

    // Using a prepared statement to prevent SQL injection
    $stmt = $conn->prepare("SELECT * FROM application_form WHERE app_no = ?");
    $stmt->bind_param("s", $appNo);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();

        // Define the file path prefix
        $filePathPrefix = '../management/form/admissions/formenter/';

        // Function to generate HTML for files
        function generateFileHtml($filePath, $filePathPrefix) {
            $fullPath = $filePathPrefix . $filePath;
            $fileExtension = pathinfo($fullPath, PATHINFO_EXTENSION);
            $html = '';

            switch (strtolower($fileExtension)) {
                case 'jpg':
                case 'jpeg':
                case 'png':
                case 'gif':
                    $html = '<img src="' . htmlspecialchars($fullPath) . '" class="img-fluid" alt="Uploaded Image">';
                    break;
                case 'pdf':
                    $html = '<embed src="' . htmlspecialchars($fullPath) . '" type="application/pdf" width="100%" height="500px" />';
                    break;
                default:
                    $html = '<a href="' . htmlspecialchars($fullPath) . '" target="_blank">View File</a>';
                    break;
            }

            return $html;
        }

        // HTML for the modal
        $html = '
               <div class="formbold-main-wrapper">
                          <div class="formbold-form-wrapper container">
                           <div class="row">
                           <div class="col-md-6">
                              <div class="formbold-mb-5">
                                <label for="name" class="formbold-form-label">Application Number</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['app_no']) . '</p>
                              </div>
                              <div class="formbold-mb-5">
                                <label for="status" class="formbold-form-label">Status</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['statusapp']) . '</p>
                              </div>
                              </div>
                              <div class="col-md-6">
                              <div class="formbold-mb-5 text-center">
                                ' . generateFileHtml($row['passport_photo_path'], $filePathPrefix) . '
                              </div>
                              </div>
                             <div class="formbold-mb-5">
                                <h4>Student Information</h4>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="first_name" class="formbold-form-label">First Name</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['first_name']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="last_name" class="formbold-form-label">Last Name</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['last_name']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="date_of_birth" class="formbold-form-label">Date of Birth</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['date_of_birth']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="gender" class="formbold-form-label">Gender</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['gender']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="email" class="formbold-form-label">Email</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['email']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="mobile" class="formbold-form-label">Mobile</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['mobile']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="marital_status" class="formbold-form-label">Marital Status</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['marital_status']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="differently_abled" class="formbold-form-label">Differently Abled</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['differently_abled']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="caste" class="formbold-form-label">Caste</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['caste']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="religion" class="formbold-form-label">Religion</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['religion']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="nationality" class="formbold-form-label">Nationality</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['nationality']) . '</p>
                            </div>
                            <div class="formbold-mb-5">
                                <h4>Education Strength</h4>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="qualification" class="formbold-form-label">Qualification</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['qualification']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="degree_name" class="formbold-form-label">Degree Name</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['degree_name']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="graduation_year" class="formbold-form-label">Graduation Year</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['graduation_year']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="university" class="formbold-form-label">University</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['university']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="program" class="formbold-form-label">Program</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['program']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="percentage" class="formbold-form-label">Percentage</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['percentage']) . '</p>
                            </div>
                            <div class="formbold-mb-5">
                                <h4>Family Information</h4>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="fathers_name" class="formbold-form-label">Father\'s Name</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['fathers_name']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="mothers_name" class="formbold-form-label">Mother\'s Name</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['mothers_name']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="father_occupation" class="formbold-form-label">Father\'s Occupation</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['father_occupation']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="mother_occupation" class="formbold-form-label">Mother\'s Occupation</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['mother_occupation']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="fathers_annual_income" class="formbold-form-label">Father\'s Annual Income</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['fathers_annual_income']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="mothers_annual_income" class="formbold-form-label">Mother\'s Annual Income</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['mothers_annual_income']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="fathers_mobile" class="formbold-form-label">Father\'s Mobile</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['fathers_mobile']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="mothers_mobile_number" class="formbold-form-label">Mother\'s Mobile Number</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['mothers_mobile_number']) . '</p>
                            </div>
                            <div class="formbold-mb-5">
                                <h4>Address Information</h4>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="permanent_street_address1" class="formbold-form-label">Permanent Street Address 1</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['permanent_street_address1']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="communication_street_address1" class="formbold-form-label">Communication Street Address 1</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['communication_street_address1']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="permanent_street_address2" class="formbold-form-label">Permanent Street Address 2</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['permanent_street_address2']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="communication_street_address2" class="formbold-form-label">Communication Street Address 2</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['communication_street_address2']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="permanent_street_city" class="formbold-form-label">Permanent City</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['permanent_city']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="communication_street_city" class="formbold-form-label">Communication City</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['communication_city']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="permanent_street_state" class="formbold-form-label">Permanent State</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['permanent_state']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="communication_street_state" class="formbold-form-label">Communication State</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['communication_state']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="permanent_street_pin_code" class="formbold-form-label">Permanent Pin Code</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['permanent_postal_code']) . '</p>
                            </div>
                            <div class="formbold-mb-5 col-md-6">
                                <label for="communication_street_pin_code" class="formbold-form-label">Communication Pin Code</label>
                                <p class="formbold-form-input">' . htmlspecialchars($row['communication_postal_code']) . '</p>
                            </div>

                              <div class="formbold-mb-5">
                                <h4>Other Documents</h4>
                              </div>
                             
                              <div class="formbold-mb-5 col-md-6">
                                '. generateFileHtml($row['address_proof_path'], $filePathPrefix) . '
                              </div>
                              <div class="formbold-mb-5 col-md-6">
                               ' . generateFileHtml($row['degree_certificate_path'], $filePathPrefix) . '
                              </div>
                          </div>
                        </div>';
        echo $html;
    } else {
        echo 'No application found with the provided application number.';
    }

    $stmt->close();
} else {
    echo 'Application number is not provided.';
}

$conn->close();
?>
