Chart.defaults.global.defaultFontFamily = '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
Chart.defaults.global.defaultFontColor = '#292b2c';

// Fetch data from the server
fetch('./config/data.php')
    .then(response => response.json())
    .then(data => {
        // Extract labels and data points from the fetched data
        const labels = data.map(entry => entry.date);
        const dataPoints = data.map(entry => entry.count);

        // Format dates to "day month"
        const formattedLabels = labels.map(date => {
            const d = new Date(date);
            const options = { day: '2-digit', month: 'short' }; // Format like "05 May"
            return d.toLocaleDateString('en-GB', options);
        });

        // Get the current date and calculate the next 30 days
        const currentDate = new Date();
        const futureDates = Array.from({ length: 30 }, (_, i) => {
            const futureDate = new Date(currentDate);
            futureDate.setDate(currentDate.getDate() + i + 1);
            const options = { day: '2-digit', month: 'short' }; // Format like "05 May"
            return futureDate.toLocaleDateString('en-GB', options);
        });

        // Combine formattedLabels with futureDates, ensuring we only have unique dates
        const allLabels = [...new Set([...formattedLabels, ...futureDates])];

        // Area Chart Example
        var ctx = document.getElementById("myAreaChart").getContext('2d');
        var myLineChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: allLabels,
                datasets: [{
                    label: "Applications",
                    lineTension: 0.3,
                    backgroundColor: "rgba(2,117,216,0.2)",
                    borderColor: "rgba(2,117,216,1)",
                    pointRadius: 10,
                    pointBackgroundColor: "rgba(2,117,216,1)",
                    pointBorderColor: "rgba(255,255,255,0.8)",
                    pointHoverRadius: 10,
                    pointHoverBackgroundColor: "rgba(2,117,216,1)",
                    pointHitRadius: 100,
                    pointBorderWidth: 2,
                    data: dataPoints,
                }],
            },
            options: {
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false
                        },
                        ticks: {
                            maxTicksLimit: 30,
                            callback: function(value) {
                                return value;
                            }
                        }
                    }],
                    yAxes: [{
                        ticks: {
                            min: 0,
                            max: Math.max(...dataPoints) + 100, // Set max dynamically
                            stepSize: 10, // Define the step size for the y-axis
                            maxTicksLimit: 10
                        },
                        gridLines: {
                            color: "rgba(0, 0, 0, .125)",
                        }
                    }],
                },
                legend: {
                    display: false
                }
            }
        });
    })
    .catch(error => console.error('Error fetching data:', error));
