<?php
session_start();
$mobile = $_SESSION["mobile"]; 

include '../../../../config/db.php'; 
require('../fpdf/fpdf.php'); // Include the FPDF library

// Create connection
$conn = new mysqli($servername, $username, $password, $database);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
// Prepare and bind statement to fetch all values based on mobile number
$stmt = $conn->prepare("SELECT * FROM application_form WHERE mobile = ?");
$stmt->bind_param("s", $mobile);

// Execute statement
$stmt->execute();

// Get result
$result = $stmt->get_result();
// Initialize PDF
class PDF extends FPDF {
    // Page header

  
    function Header() {
        $left = '../uploads/pdf_header/left.png';  
        $right = '../uploads/pdf_header/right.png';

        // Insert left and right images
        $this->Image($left, 30, 6, 120); // Adjust the position and size as needed
        $this->Image($right, 150, 6, 20);
        $this->Ln(25);
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'APPLICATION FORM',0,1,'C');
        $this->SetFont('Arial','',10);
        $this->Cell(0,10,'ADMISSION TO POST GRADUATE DIPLOMA COURSES IN ENTREPRENEURSHIP & INNOVATION 2024 -2025',0,1,'C');
        $this->Ln(10);
    }

    // Page footer
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial','I',8);
        $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
    }
}

// Create PDF
$pdf = new PDF();
$pdf->AliasNbPages();
$pdf->AddPage();

// Set font for content
$pdf->SetFont('Arial','',10);

// Define cell width
$cell_width_key = 80;
$cell_width_value = 0; // 0 means the cell extends up to the right margin of the page

while ($row = $result->fetch_assoc()) {
    $app_no = $row['app_no']; 
       
    $pdf->Cell(20, 0, '');
    
    $pdf->Ln(-6);
    $pdf->Cell(160, 10,);
    $pdf->Image('../' . $row['passport_photo_path'], $pdf->GetX(), $pdf->GetY(), 20); 
    $pdf->Cell(19, 65, 'Passport Size Photo', 0, 1, 'C'); // Text below photo
    $pdf->Ln(-65); 
    // Section 1: Application Details
    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Application Number', 0);
    $pdf->Cell($cell_width_value, 10, $row['app_no'], 0);
    $pdf->Ln();

    // Section 2: Personal Details
    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'First Name', 0);
    $pdf->Cell($cell_width_value, 10, $row['first_name'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Last Name', 0);
    $pdf->Cell($cell_width_value, 10, $row['last_name'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Date of Birth', 0);
    $pdf->Cell($cell_width_value, 10, $row['date_of_birth'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Gender', 0);
    $pdf->Cell($cell_width_value, 10, $row['gender'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Email', 0);
    $pdf->Cell($cell_width_value, 10, $row['email'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Mobile', 0);
    $pdf->Cell($cell_width_value, 10, $row['mobile'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Caste', 0);
    $pdf->Cell($cell_width_value, 10, $row['caste'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Religion', 0);
    $pdf->Cell($cell_width_value, 10, $row['religion'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Nationality', 0);
    $pdf->Cell($cell_width_value, 10, $row['nationality'], 0);
    $pdf->Ln();

    // Section 3: Course Details
    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Program', 0);
    $pdf->Cell($cell_width_value, 10, $row['program'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Field of Study', 0);
    $pdf->Cell($cell_width_value, 10, $row['field'], 0);
    $pdf->Ln();
    // Additional Fields
    $pdf->Cell(10, 2);
    $pdf->Cell($cell_width_key, 10, 'Qualification', 0);
    $pdf->Cell($cell_width_value, 10, $row['qualification'], 0);
    $pdf->Ln();
    
    $pdf->Cell(10, 2);
    $pdf->Cell($cell_width_key, 10, 'University', 0);
    $pdf->Cell($cell_width_value, 10, $row['university'], 0);
    $pdf->Ln();
    
    $pdf->Cell(10, 2);
    $pdf->Cell($cell_width_key, 10, 'Degree Name', 0);
    $pdf->Cell($cell_width_value, 10, $row['degree_name'], 0);
    $pdf->Ln();
    
    $pdf->Cell(10, 2);
    $pdf->Cell($cell_width_key, 10, 'Graduation Year', 0);
    $pdf->Cell($cell_width_value, 10, $row['graduation_year'], 0);
    $pdf->Ln();
    
    $pdf->Cell(10, 2);
    $pdf->Cell($cell_width_key, 10, 'Percentage', 0);
    $pdf->Cell($cell_width_value, 10, $row['percentage'], 0);
    $pdf->Ln();
    // Section 4: Additional Information
    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Differently Abled', 0);
    $pdf->Cell($cell_width_value, 10, $row['differently_abled'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Marital Status', 0);
    $pdf->Cell($cell_width_value, 10, $row['marital_status'], 0);
    $pdf->Ln();

    // Section 5: Parent Details
    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Father\'s Name', 0);
    $pdf->Cell($cell_width_value, 10, $row['fathers_name'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Father\'s Occupation', 0);
    $pdf->Cell($cell_width_value, 10, $row['father_occupation'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Father\'s Annual Income', 0);
    $pdf->Cell($cell_width_value, 10, $row['fathers_annual_income'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Father\'s Mobile', 0);
    $pdf->Cell($cell_width_value, 10, $row['fathers_mobile'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Mother\'s Name', 0);
    $pdf->Cell($cell_width_value, 10, $row['mothers_name'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Mother\'s Occupation', 0);
    $pdf->Cell($cell_width_value, 10, $row['mother_occupation'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Mother\'s Annual Income', 0);
    $pdf->Cell($cell_width_value, 10, $row['mothers_annual_income'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Mother\'s Mobile Number', 0);
    $pdf->Cell($cell_width_value, 10, $row['mothers_mobile_number'], 0);
    $pdf->Ln();

    // Section 6: Permanent Address
    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Permanent Street Address 1', 0);
    $pdf->Cell($cell_width_value, 10, $row['permanent_street_address1'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Permanent Street Address 2', 0);
    $pdf->Cell($cell_width_value, 10, $row['permanent_street_address2'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Permanent City', 0);
    $pdf->Cell($cell_width_value, 10, $row['permanent_city'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Permanent State', 0);
    $pdf->Cell($cell_width_value, 10, $row['permanent_state'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Permanent Postal Code', 0);
    $pdf->Cell($cell_width_value, 10, $row['permanent_postal_code'], 0);
    $pdf->Ln();

    // Section 7: Communication Address
    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Communication Street Address 1', 0);
    $pdf->Cell($cell_width_value, 10, $row['communication_street_address1'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Communication Street Address 2', 0);
    $pdf->Cell($cell_width_value, 10, $row['communication_street_address2'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Communication City', 0);
    $pdf->Cell($cell_width_value, 10, $row['communication_city'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Communication State', 0);
    $pdf->Cell($cell_width_value, 10, $row['communication_state'], 0);
    $pdf->Ln();

    $pdf->Cell(10, 2,);
    $pdf->Cell($cell_width_key, 10, 'Communication Postal Code', 0);
    $pdf->Cell($cell_width_value, 10, $row['communication_postal_code'], 0);
    $pdf->Ln();

     
  

   
}
// Save the PDF to a file
$file_path = 'upload/EDIITNAPPLICATION' . $app_no . '.pdf';
$pdf->Output($file_path, 'F');

// Redirect to mail script
header("Location: mail.php?file=" . urlencode($file_path) . "&userID=" . urlencode($app_no));

// Close statement and connection
$stmt->close();
$conn->close();
?>